/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.ResultBasicMetadata;
import com.easy.query.core.basic.jdbc.executor.ResultMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.AbstractMapToStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.props.BasicJdbcProperty;
import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.JdbcTypes;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class MapStreamIterator<T>
extends AbstractMapToStreamIterator<T> {
    private ResultSetMetaData rsmd;
    private ResultBasicMetadata[] resultBasicMetadatas;
    private int mapCount = -1;

    public MapStreamIterator(ExecutorContext context, StreamResultSet streamResult, ResultMetadata<T> resultMetadata) throws SQLException {
        super(context, streamResult, resultMetadata);
    }

    @Override
    protected void init0() throws SQLException {
        this.rsmd = this.streamResultSet.getMetaData();
        int columnCount = this.rsmd.getColumnCount();
        this.resultBasicMetadatas = new ResultBasicMetadata[columnCount];
    }

    @Override
    protected T mapTo() throws SQLException {
        ++this.mapCount;
        Class clazz = this.resultMetadata.getResultClass();
        Map map = EasyClassUtil.newMapInstanceOrNull(clazz);
        if (map == null) {
            throw new SQLException("cant create map:" + EasyClassUtil.getSimpleName(clazz));
        }
        JdbcTypeHandlerManager easyJdbcTypeHandler = this.context.getRuntimeContext().getJdbcTypeHandlerManager();
        for (int i = 0; i < this.resultBasicMetadatas.length; ++i) {
            if (this.mapCount == 0) {
                String colName = this.getColName(this.rsmd, i + 1);
                int columnType = this.rsmd.getColumnType(i + 1);
                Class<?> propertyType = JdbcTypes.jdbcJavaTypes.get(columnType);
                JdbcTypeHandler handler = easyJdbcTypeHandler.getHandler(propertyType);
                BasicJdbcProperty dataReader = new BasicJdbcProperty(i, propertyType);
                this.resultBasicMetadatas[i] = new ResultBasicMetadata(colName, dataReader, handler);
            }
            ResultBasicMetadata resultBasicMetadata = this.resultBasicMetadatas[i];
            Object value = resultBasicMetadata.getJdbcTypeHandler().getValue(resultBasicMetadata.getDataReader(), this.streamResultSet);
            Object o = map.put(resultBasicMetadata.getColumnName(), value);
            if (o == null) continue;
            throw new IllegalStateException("Duplicate key found: " + resultBasicMetadata.getColumnName());
        }
        return (T)EasyObjectUtil.typeCastNullable(map);
    }
}

