/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.ResultBasicMetadata;
import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.ResultMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.AbstractMapToStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.props.BasicJdbcProperty;
import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapTypeStreamIterator
extends AbstractMapToStreamIterator<Map<String, Object>> {
    private ResultSetMetaData rsmd;
    private ResultBasicMetadata[] resultBasicMetadatas;
    private int mapCount = -1;

    public MapTypeStreamIterator(ExecutorContext context, StreamResultSet streamResult, ResultMetadata<Map<String, Object>> resultMetadata) throws SQLException {
        super(context, streamResult, resultMetadata);
    }

    @Override
    protected void init0() throws SQLException {
        this.rsmd = this.streamResultSet.getMetaData();
        int columnCount = this.rsmd.getColumnCount();
        this.resultBasicMetadatas = new ResultBasicMetadata[columnCount];
    }

    private Class<?> getPropTypeOrObjectType(int index) {
        ResultColumnMetadata[] mapPropTypes = this.context.getExpressionContext().getResultPropTypes();
        if (mapPropTypes != null) {
            return mapPropTypes[index].getPropertyType();
        }
        return Object.class;
    }

    @Override
    protected Map<String, Object> mapTo() throws SQLException {
        ++this.mapCount;
        int length = this.context.getExpressionContext().getResultPropTypes().length;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(length);
        JdbcTypeHandlerManager easyJdbcTypeHandler = this.context.getRuntimeContext().getJdbcTypeHandlerManager();
        if (this.mapCount == 0) {
            this.resultBasicMetadatas = new ResultBasicMetadata[length];
        }
        for (int i = 0; i < this.resultBasicMetadatas.length; ++i) {
            if (this.mapCount == 0) {
                Class<?> propType = this.getPropTypeOrObjectType(i);
                String colName = this.getColName(this.rsmd, i + 1);
                JdbcTypeHandler handler = easyJdbcTypeHandler.getHandler(propType);
                BasicJdbcProperty dataReader = new BasicJdbcProperty(i, propType);
                this.resultBasicMetadatas[i] = new ResultBasicMetadata(colName, dataReader, handler);
            }
            ResultBasicMetadata resultBasicMetadata = this.resultBasicMetadatas[i];
            Object value = resultBasicMetadata.getJdbcTypeHandler().getValue(resultBasicMetadata.getDataReader(), this.streamResultSet);
            Object o = map.put(resultBasicMetadata.getColumnName(), value);
            if (o == null) continue;
            throw new IllegalStateException("Duplicate key found: " + resultBasicMetadata.getColumnName());
        }
        return map;
    }
}

