/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.ShardingStreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.aggregation.AggregationUnitFactory;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.AggregateValue;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.EasyOrderStreamMergeResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.GroupValue;
import com.easy.query.core.basic.jdbc.executor.internal.merge.segment.PropertyGroup;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.expression.func.AggregationType;
import com.easy.query.core.expression.segment.FuncColumnSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.sharding.context.ColumnIndexFuncColumnSegment;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;

public class EasyGroupByOrderStreamMergeResultSet
implements ShardingStreamResultSet {
    private static final Log log = LogFactory.getLog(EasyGroupByOrderStreamMergeResultSet.class);
    private final StreamMergeContext streamMergeContext;
    private final List<StreamResultSet> streamResultSets;
    private final Queue<StreamResultSet> queue;
    private final ResultSetMetaData resultSetMetaData;
    private StreamResultSet currentStreamResult;
    private final List<Object> currentRow;
    private final int columnCount;
    private final int[] selectColumns;
    private List<Object> currentGroupValues;
    private boolean skipFirst;
    private boolean wasNull;
    private boolean closed = false;

    public EasyGroupByOrderStreamMergeResultSet(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        this.streamMergeContext = streamMergeContext;
        this.streamResultSets = streamResultSets;
        this.queue = new PriorityQueue<StreamResultSet>(streamResultSets.size());
        this.skipFirst = true;
        this.setOrderStreamResult();
        this.resultSetMetaData = this.getResultSetMetaData();
        this.columnCount = this.resultSetMetaData.getColumnCount();
        this.currentRow = new ArrayList<Object>(this.columnCount);
        List<PropertyGroup> groups = streamMergeContext.getGroups();
        this.selectColumns = new int[streamMergeContext.getSelectColumns().getSQLSegments().size()];
        for (PropertyGroup group : groups) {
            int columnIndex = group.columnIndex();
            if (columnIndex < 0) continue;
            this.selectColumns[columnIndex] = 1;
        }
    }

    private void setOrderStreamResult() throws SQLException {
        for (StreamResultSet streamResult : this.streamResultSets) {
            EasyOrderStreamMergeResultSet easyOrderStreamMergeResult = new EasyOrderStreamMergeResultSet(this.streamMergeContext, streamResult);
            if (!easyOrderStreamMergeResult.hasElement()) continue;
            easyOrderStreamMergeResult.skipFirst();
            this.queue.offer(easyOrderStreamMergeResult);
        }
        this.currentStreamResult = this.queue.isEmpty() ? EasyCollectionUtil.firstOrNull(this.streamResultSets) : this.queue.peek();
        this.currentGroupValues = this.queue.isEmpty() ? Collections.emptyList() : new GroupValue(this.streamMergeContext, this.currentStreamResult).getGroupValues();
    }

    private ResultSetMetaData getResultSetMetaData() throws SQLException {
        return this.currentStreamResult.getMetaData();
    }

    @Override
    public boolean hasElement() {
        return this.currentStreamResult.hasElement();
    }

    @Override
    public boolean skipFirst() {
        return this.skipFirst;
    }

    @Override
    public boolean next() throws SQLException {
        this.currentRow.clear();
        if (this.queue.isEmpty()) {
            return false;
        }
        if (this.skipFirst) {
            this.next0();
        }
        if (this.aggregateCurrentGroupByRowAndNext()) {
            this.currentGroupValues = new GroupValue(this.streamMergeContext, this.currentStreamResult).getGroupValues();
        }
        return true;
    }

    private boolean next0() throws SQLException {
        if (this.queue.isEmpty()) {
            return false;
        }
        if (this.skipFirst) {
            this.skipFirst = false;
            return true;
        }
        StreamResultSet first = this.queue.poll();
        if (first.next()) {
            this.queue.offer(first);
        }
        if (this.queue.isEmpty()) {
            return false;
        }
        this.currentStreamResult = this.queue.peek();
        return true;
    }

    private boolean aggregateCurrentGroupByRowAndNext() throws SQLException {
        boolean result = false;
        boolean cachedRow = false;
        List<AggregateValue> aggregationValues = this.createAggregationUnitValues();
        while (this.currentGroupValues.equals(new GroupValue(this.streamMergeContext, this.currentStreamResult).getGroupValues())) {
            this.aggregate(aggregationValues);
            if (!cachedRow) {
                this.cacheCurrentRow();
                cachedRow = true;
            }
            if (result = this.next0()) continue;
        }
        this.setAggregationValueToCurrentRow(aggregationValues);
        return result;
    }

    private void setAggregationValueToCurrentRow(List<AggregateValue> aggregationValues) {
        for (AggregateValue aggregationValue : aggregationValues) {
            this.currentRow.set(aggregationValue.getColumnIndex(), aggregationValue.getAggregationUnit().getResult());
        }
    }

    private void aggregate(List<AggregateValue> aggregationValues) throws SQLException {
        for (AggregateValue aggregationValue : aggregationValues) {
            ArrayList comparables = new ArrayList(2);
            if (EasyCollectionUtil.isEmpty(aggregationValue.getAggregateValues())) {
                Comparable<?> value = this.getAggregationValue(aggregationValue.getColumnIndex());
                comparables.add(value);
            } else {
                for (AggregateValue aggregateValue : aggregationValue.getAggregateValues()) {
                    Comparable<?> value = this.getAggregationValue(aggregateValue.getColumnIndex());
                    comparables.add(value);
                }
            }
            aggregationValue.getAggregationUnit().merge(comparables);
        }
    }

    private Comparable<?> getAggregationValue(int columnIndex) throws SQLException {
        Object result = this.currentStreamResult.getObject(columnIndex + 1);
        if (null == result || result instanceof Comparable) {
            return (Comparable)result;
        }
        throw new EasyQuerySQLCommandException("aggregation value must implements comparable");
    }

    private List<AggregateValue> createAggregationUnitValues() {
        List<SQLSegment> sqlSegments = this.streamMergeContext.getSelectColumns().getSQLSegments();
        ArrayList<AggregateValue> aggregationUnits = new ArrayList<AggregateValue>(this.columnCount);
        for (int i = 0; i < this.selectColumns.length; ++i) {
            boolean aggregateColumn;
            boolean bl = aggregateColumn = this.selectColumns[i] == 0;
            if (!aggregateColumn) continue;
            SQLSegment sqlSegment = sqlSegments.get(i);
            boolean isAggregateColumn = EasySQLSegmentUtil.isAggregateColumn(sqlSegment);
            if (!isAggregateColumn) {
                throw new UnsupportedOperationException("unknown aggregate column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
            }
            FuncColumnSegment aggregationColumnSegment = (FuncColumnSegment)sqlSegment;
            AggregateValue aggregateValue = new AggregateValue(i, AggregationUnitFactory.create(aggregationColumnSegment.getAggregationType()));
            if (Objects.equals((Object)AggregationType.AVG, (Object)aggregationColumnSegment.getAggregationType())) {
                Map<AggregationType, ColumnIndexFuncColumnSegment> aggregationTypeFuncColumnSegmentMap = this.streamMergeContext.getGroupMergeContext().getColumnMapping().get(aggregationColumnSegment);
                if (aggregationTypeFuncColumnSegmentMap == null) {
                    throw new UnsupportedOperationException("not found sum or count projects, avg column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
                }
                ColumnIndexFuncColumnSegment countAvgColumnSegment = aggregationTypeFuncColumnSegmentMap.get((Object)AggregationType.COUNT);
                if (countAvgColumnSegment == null) {
                    throw new UnsupportedOperationException("not found count projects, avg column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
                }
                AggregateValue avgCountAggregateValue = new AggregateValue(countAvgColumnSegment.getColumnIndex(), AggregationUnitFactory.create(countAvgColumnSegment.getFuncColumnSegment().getAggregationType()));
                aggregateValue.addAggregateValue(avgCountAggregateValue);
                ColumnIndexFuncColumnSegment sumAvgColumnSegment = aggregationTypeFuncColumnSegmentMap.get((Object)AggregationType.SUM);
                if (sumAvgColumnSegment == null) {
                    throw new UnsupportedOperationException("not found sum projects, avg column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
                }
                AggregateValue sumCountAggregateValue = new AggregateValue(sumAvgColumnSegment.getColumnIndex(), AggregationUnitFactory.create(sumAvgColumnSegment.getFuncColumnSegment().getAggregationType()));
                aggregateValue.addAggregateValue(sumCountAggregateValue);
            }
            aggregationUnits.add(aggregateValue);
        }
        return aggregationUnits;
    }

    private void cacheCurrentRow() throws SQLException {
        for (int i = 0; i < this.columnCount; ++i) {
            this.currentRow.add(this.currentStreamResult.getObject(i + 1));
        }
    }

    private void setWasNull(boolean wasNull) {
        this.wasNull = wasNull;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return value;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (T)EasyObjectUtil.typeCastNullable(value);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (SQLXML)value;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (Timestamp)value;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (Time)value;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (String)value;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (Date)value;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return 0;
        }
        return ((BigDecimal)value).shortValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return 0L;
        }
        return ((BigDecimal)value).longValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return 0;
        }
        return ((BigDecimal)value).intValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return 0.0f;
        }
        return ((BigDecimal)value).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return 0.0;
        }
        return ((BigDecimal)value).doubleValue();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (Clob)value;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return 0;
        }
        return (Byte)value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return new byte[0];
        }
        return (byte[])value;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (Blob)value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object value = this.currentRow.get(columnIndex - 1);
        this.setWasNull(value == null);
        return (BigDecimal)value;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.currentRow.clear();
        for (StreamResultSet streamResultSet : this.streamResultSets) {
            try {
                streamResultSet.close();
            }
            catch (Exception exception) {
                log.error("close stream result set error.", exception);
            }
        }
    }
}

