/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.OrderStreamMergeResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.ShardingStreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.EasyOrderStreamMergeResultSet;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyCollectionUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class EasyMultiOrderStreamMergeResultSet
implements ShardingStreamResultSet {
    private static final Log log = LogFactory.getLog(EasyMultiOrderStreamMergeResultSet.class);
    private final StreamMergeContext streamMergeContext;
    private final List<StreamResultSet> orderStreamMergeResultSets;
    private final Queue<OrderStreamMergeResultSet> queue;
    private StreamResultSet currentStreamResult;
    private boolean skipFirst;
    private boolean closed = false;

    public EasyMultiOrderStreamMergeResultSet(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        this.streamMergeContext = streamMergeContext;
        this.orderStreamMergeResultSets = streamResultSets;
        this.queue = new PriorityQueue<OrderStreamMergeResultSet>(streamResultSets.size());
        this.skipFirst = true;
        this.setOrderStreamResult();
    }

    private void setOrderStreamResult() throws SQLException {
        for (StreamResultSet orderStreamMergeResult : this.orderStreamMergeResultSets) {
            EasyOrderStreamMergeResultSet easyOrderStreamMergeResult = new EasyOrderStreamMergeResultSet(this.streamMergeContext, orderStreamMergeResult);
            if (!easyOrderStreamMergeResult.hasElement()) continue;
            easyOrderStreamMergeResult.skipFirst();
            this.queue.offer(easyOrderStreamMergeResult);
        }
        this.currentStreamResult = this.queue.isEmpty() ? EasyCollectionUtil.firstOrNull(this.orderStreamMergeResultSets) : (StreamResultSet)this.queue.peek();
    }

    @Override
    public boolean hasElement() {
        return this.currentStreamResult != null && this.currentStreamResult.hasElement();
    }

    @Override
    public boolean skipFirst() {
        if (this.skipFirst) {
            this.skipFirst = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.queue.isEmpty()) {
            return false;
        }
        if (this.skipFirst) {
            this.skipFirst = false;
            return true;
        }
        OrderStreamMergeResultSet first = this.queue.poll();
        if (first.next()) {
            this.queue.offer(first);
        }
        if (this.queue.isEmpty()) {
            return false;
        }
        this.currentStreamResult = this.queue.peek();
        return true;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.currentStreamResult.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.currentStreamResult.getObject(columnIndex, type);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.currentStreamResult.wasNull();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.currentStreamResult.getMetaData();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.currentStreamResult.getSQLXML(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.currentStreamResult.getTimestamp(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.currentStreamResult.getTime(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.currentStreamResult.getString(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.currentStreamResult.getDate(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.currentStreamResult.getShort(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.currentStreamResult.getLong(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.currentStreamResult.getInt(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.currentStreamResult.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.currentStreamResult.getDouble(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.currentStreamResult.getClob(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.currentStreamResult.getByte(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.currentStreamResult.getBytes(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.currentStreamResult.getBoolean(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.currentStreamResult.getBlob(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.currentStreamResult.getBigDecimal(columnIndex);
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (StreamResultSet streamResultSet : this.orderStreamMergeResultSets) {
            try {
                streamResultSet.close();
            }
            catch (Exception exception) {
                log.error("close stream result set error.", exception);
            }
        }
    }
}

