/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.ShardingStreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.sharding.context.StreamMergeContext;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class EasyPaginationStreamMergeResultSet
implements ShardingStreamResultSet {
    private final StreamMergeContext streamMergeContext;
    private final StreamResultSet streamResultSet;
    private final long offset;
    private final long rows;
    private long realOffset;
    private long realRows;
    private boolean closed = false;

    public EasyPaginationStreamMergeResultSet(StreamMergeContext streamMergeContext, StreamResultSet streamResultSet) throws SQLException {
        this(streamMergeContext, streamResultSet, streamMergeContext.getMergeOffset(), streamMergeContext.getMergeRows());
    }

    public EasyPaginationStreamMergeResultSet(StreamMergeContext streamMergeContext, StreamResultSet streamResultSet, long offset, long rows) throws SQLException {
        this.streamMergeContext = streamMergeContext;
        this.offset = offset;
        this.rows = rows;
        this.realOffset = 0L;
        this.realRows = 0L;
        this.streamResultSet = streamResultSet;
    }

    @Override
    public boolean hasElement() {
        return this.streamResultSet.hasElement();
    }

    @Override
    public boolean skipFirst() {
        return this.streamResultSet.skipFirst();
    }

    @Override
    public boolean next() throws SQLException {
        while (this.offset > this.realOffset) {
            boolean has = this.streamResultSet.next();
            ++this.realOffset;
            if (has) continue;
            return false;
        }
        boolean next = this.streamResultSet.next();
        if (next && this.rows > 0L) {
            ++this.realRows;
            if (this.realRows > this.rows) {
                return false;
            }
        }
        return next;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.streamResultSet.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.streamResultSet.getObject(columnIndex, type);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.streamResultSet.wasNull();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.streamResultSet.getMetaData();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.streamResultSet.getSQLXML(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.streamResultSet.getTimestamp(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.streamResultSet.getTime(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.streamResultSet.getString(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.streamResultSet.getDate(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.streamResultSet.getShort(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.streamResultSet.getLong(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.streamResultSet.getInt(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.streamResultSet.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.streamResultSet.getDouble(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.streamResultSet.getClob(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.streamResultSet.getByte(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.streamResultSet.getBytes(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.streamResultSet.getBoolean(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.streamResultSet.getBlob(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.streamResultSet.getBigDecimal(columnIndex);
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.streamResultSet.close();
    }
}

