/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.InMemoryStreamMergeResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.row.MemoryResultSetRow;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyObjectUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractInMemoryStreamMergeResultSet
implements InMemoryStreamMergeResultSet {
    protected final Iterator<MemoryResultSetRow> memoryResultSetRows;
    protected final List<MemoryResultSetRow> memoryResultSetRowList;
    protected final ResultSetMetaData metaData;
    protected final int columnCount;
    protected final StreamMergeContext streamMergeContext;
    protected final int reallyCount;
    private MemoryResultSetRow currentResultSetRow;
    private boolean wasNull;
    private boolean skipFirst;
    private boolean closed = false;

    public AbstractInMemoryStreamMergeResultSet(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        this.streamMergeContext = streamMergeContext;
        this.metaData = streamResultSets.get(0).getMetaData();
        this.columnCount = this.metaData.getColumnCount();
        this.memoryResultSetRowList = this.init(streamMergeContext, streamResultSets);
        this.reallyCount = this.memoryResultSetRowList.size();
        this.memoryResultSetRows = this.memoryResultSetRowList.iterator();
        if (this.memoryResultSetRows.hasNext()) {
            this.currentResultSetRow = this.memoryResultSetRows.next();
        }
        this.skipFirst = true;
    }

    protected abstract List<MemoryResultSetRow> init(StreamMergeContext var1, List<StreamResultSet> var2) throws SQLException;

    @Override
    public boolean hasElement() {
        return this.currentResultSetRow != null;
    }

    @Override
    public boolean skipFirst() {
        if (this.skipFirst) {
            this.skipFirst = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.skipFirst) {
            this.skipFirst = false;
            return this.currentResultSetRow != null;
        }
        if (this.memoryResultSetRows.hasNext()) {
            this.currentResultSetRow = this.memoryResultSetRows.next();
            return true;
        }
        this.currentResultSetRow = null;
        return false;
    }

    private void setWasNull(boolean wasNull) {
        this.wasNull = wasNull;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return value;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (T)EasyObjectUtil.typeCastNullable(value);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (SQLXML)value;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (this.wasNull) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            long ts = ((LocalDate)value).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            return new Timestamp(ts);
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        return (Timestamp)value;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (this.wasNull) {
            return null;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof LocalTime) {
            return Time.valueOf((LocalTime)value);
        }
        return (Time)value;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (String)value;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (Date)value;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (value == null) {
            return 0;
        }
        return this.getNumberDefaultValue(value, Number::shortValue, () -> (short)((Short)value));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (value == null) {
            return 0L;
        }
        return this.getNumberDefaultValue(value, BigDecimal::longValue, () -> (long)((Long)value));
    }

    private <T> T getNumberDefaultValue(Object value, Function<BigDecimal, T> function, Supplier<T> supplier) {
        if (value instanceof BigDecimal) {
            return function.apply((BigDecimal)value);
        }
        return supplier.get();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (value == null) {
            return 0;
        }
        return this.getNumberDefaultValue(value, BigDecimal::intValue, () -> (int)((Integer)value));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (value == null) {
            return 0.0f;
        }
        return this.getNumberDefaultValue(value, BigDecimal::floatValue, () -> Float.valueOf(((Float)value).floatValue())).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (value == null) {
            return 0.0;
        }
        return this.getNumberDefaultValue(value, BigDecimal::doubleValue, () -> (double)((Double)value));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (Clob)value;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (value == null) {
            return 0;
        }
        return (Byte)value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (byte[])value;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (Blob)value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object value = this.currentResultSetRow.getValue(columnIndex);
        this.setWasNull(value == null);
        return (BigDecimal)value;
    }

    @Override
    public int getReallyCount() {
        return this.reallyCount;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.memoryResultSetRowList.clear();
    }
}

