/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.single;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.JdbcShardingStreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.AbstractInMemoryStreamMergeResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.row.ConstMemoryResultSetRow;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.row.MemoryResultSetRow;
import com.easy.query.core.enums.MergeBehaviorEnum;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.sharding.manager.ShardingQueryCountManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class EasyCountInMemoryStreamMergeResultSet
extends AbstractInMemoryStreamMergeResultSet {
    public EasyCountInMemoryStreamMergeResultSet(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        super(streamMergeContext, streamResultSets);
    }

    @Override
    protected List<MemoryResultSetRow> init(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        int columnCount = this.metaData.getColumnCount();
        if (columnCount != 1) {
            throw new SQLException("column count " + columnCount + " !=1");
        }
        ShardingQueryCountManager shardingQueryCountManager = streamMergeContext.getRuntimeContext().getShardingQueryCountManager();
        boolean recordCount = streamMergeContext.hasBehavior(MergeBehaviorEnum.SEQUENCE_COUNT);
        long result = 0L;
        for (StreamResultSet resultSet : streamResultSets) {
            try {
                StreamResultSet streamResultSet = resultSet;
                Throwable throwable = null;
                try {
                    while (streamResultSet.next()) {
                        long rows = streamResultSet.getLong(1);
                        result += rows;
                        if (!recordCount || !(streamResultSet instanceof JdbcShardingStreamResultSet)) continue;
                        shardingQueryCountManager.addCountResult(rows, false);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (streamResultSet == null) continue;
                    if (throwable != null) {
                        try {
                            streamResultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    streamResultSet.close();
                }
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        ArrayList<MemoryResultSetRow> list = new ArrayList<MemoryResultSetRow>(1);
        list.add(new ConstMemoryResultSetRow(result));
        return list;
    }
}

