/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.unit.abstraction;

import com.easy.query.core.basic.jdbc.executor.internal.common.CommandExecuteUnit;
import com.easy.query.core.basic.jdbc.executor.internal.common.DataSourceSQLExecutorUnit;
import com.easy.query.core.basic.jdbc.executor.internal.common.SQLExecutorGroup;
import com.easy.query.core.basic.jdbc.executor.internal.unit.Executor;
import com.easy.query.core.basic.jdbc.executor.internal.unit.breaker.CircuitBreaker;
import com.easy.query.core.basic.thread.FuturesInvoker;
import com.easy.query.core.basic.thread.ShardingExecutorService;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.exception.EasyQueryTimeoutSQLException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyCollectionUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

public abstract class AbstractExecutor<TResult>
implements Executor<TResult> {
    private static final Log log = LogFactory.getLog(AbstractExecutor.class);
    protected final StreamMergeContext streamMergeContext;
    private volatile boolean stopped = false;

    public AbstractExecutor(StreamMergeContext streamMergeContext) {
        this.streamMergeContext = streamMergeContext;
    }

    private void stop() {
        this.stopped = true;
    }

    private boolean isStopped() {
        return this.stopped;
    }

    @Override
    public List<TResult> execute(DataSourceSQLExecutorUnit dataSourceSQLExecutorUnit) throws SQLException {
        try {
            return this.execute0(dataSourceSQLExecutorUnit);
        }
        catch (Throwable throwable) {
            this.stop();
            throw throwable;
        }
    }

    private List<TResult> execute0(DataSourceSQLExecutorUnit dataSourceSQLExecutorUnit) throws SQLException {
        SQLExecutorGroup<CommandExecuteUnit> first;
        List<SQLExecutorGroup<CommandExecuteUnit>> executorGroups = dataSourceSQLExecutorUnit.getSQLExecutorGroups();
        long timeoutMillis = this.streamMergeContext.getEasyQueryOption().getShardingExecuteTimeoutMillis();
        if (EasyCollectionUtil.isSingle(executorGroups) && EasyCollectionUtil.isSingle((first = EasyCollectionUtil.first(executorGroups)).getGroups())) {
            return this.executeSingle0(first, timeoutMillis);
        }
        return this.executeMulti0(dataSourceSQLExecutorUnit, timeoutMillis);
    }

    private List<TResult> executeSingle0(SQLExecutorGroup<CommandExecuteUnit> executorGroup, long timeoutMillis) throws SQLException {
        List<CommandExecuteUnit> groups = executorGroup.getGroups();
        Collection<TResult> tResults = this.groupExecute(groups, timeoutMillis);
        return new ArrayList<TResult>(tResults);
    }

    private List<TResult> executeMulti0(DataSourceSQLExecutorUnit dataSourceSQLExecutorUnit, long timeoutMillis) throws SQLException {
        List<SQLExecutorGroup<CommandExecuteUnit>> executorGroups = dataSourceSQLExecutorUnit.getSQLExecutorGroups();
        int count = EasyCollectionUtil.sum(executorGroups, o -> o.getGroups().size());
        CircuitBreaker circuitBreak = this.createCircuitBreak();
        ArrayList<TResult> result = new ArrayList<TResult>(count);
        long start = System.currentTimeMillis();
        long constTime = 0L;
        Iterator<SQLExecutorGroup<CommandExecuteUnit>> iterator = executorGroups.iterator();
        while (iterator.hasNext()) {
            if (timeoutMillis < constTime) {
                throw new EasyQueryTimeoutSQLException("sharding execute time out:" + dataSourceSQLExecutorUnit.getDataSourceName());
            }
            SQLExecutorGroup<CommandExecuteUnit> executorGroup = iterator.next();
            Collection<TResult> results = this.groupExecute(executorGroup.getGroups(), timeoutMillis - constTime);
            if (Objects.equals((Object)ConnectionModeEnum.CONNECTION_STRICTLY, (Object)dataSourceSQLExecutorUnit.getConnectionMode())) {
                this.getShardingMerger().inMemoryMerge(this.streamMergeContext, result, results);
            } else {
                result.addAll(results);
            }
            if (!iterator.hasNext()) continue;
            if (this.isStopped() || circuitBreak.terminated(this.streamMergeContext, result)) break;
            constTime = System.currentTimeMillis() - start;
        }
        return result;
    }

    private Collection<TResult> groupExecute(List<CommandExecuteUnit> commandExecuteUnits, long timeoutMillis) throws SQLException {
        if (EasyCollectionUtil.isEmpty(commandExecuteUnits)) {
            return Collections.emptyList();
        }
        if (EasyCollectionUtil.isSingle(commandExecuteUnits)) {
            TResult result = this.executeCommandUnit(EasyCollectionUtil.first(commandExecuteUnits));
            return Collections.singletonList(result);
        }
        ShardingExecutorService easyShardingExecutorService = this.streamMergeContext.getRuntimeContext().getShardingExecutorService();
        ArrayList tasks = new ArrayList(commandExecuteUnits.size());
        for (CommandExecuteUnit commandExecuteUnit : commandExecuteUnits) {
            Future<Object> task = easyShardingExecutorService.getExecutorService().submit(() -> this.executeCommandUnit(commandExecuteUnit));
            tasks.add(task);
        }
        try (FuturesInvoker invoker = new FuturesInvoker(tasks);){
            List list = invoker.get(timeoutMillis);
            return list;
        }
    }

    protected abstract TResult executeCommandUnit(CommandExecuteUnit var1) throws SQLException;

    protected abstract CircuitBreaker createCircuitBreak();
}

