/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.parameter;

import com.easy.query.core.basic.jdbc.executor.internal.common.SQLRewriteUnit;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.TableContext;
import com.easy.query.core.expression.sql.ToTableContext;
import java.util.ArrayList;
import java.util.List;

public class DefaultToSQLContext
implements ToSQLContext {
    private final List<SQLParameter> parameters;
    private final SQLRewriteUnit sqlRewriteUnit;
    private final ToTableContext toTableContext;
    private int invokeCount;

    public DefaultToSQLContext(TableContext tableContext, boolean query, String alias) {
        this(tableContext, 10, null, query, alias);
    }

    public DefaultToSQLContext(TableContext tableContext, boolean query) {
        this(tableContext, query, "t");
    }

    public DefaultToSQLContext(TableContext tableContext, SQLRewriteUnit sqlRewriteUnit, boolean query) {
        this(tableContext, 10, sqlRewriteUnit, query, "t");
    }

    public DefaultToSQLContext(TableContext tableContext, int initialCapacity, SQLRewriteUnit sqlRewriteUnit, boolean query, String alias) {
        if (tableContext.isEmpty()) {
            throw new IllegalArgumentException("invalid arguments:tableContext is empty");
        }
        this.toTableContext = tableContext.getToTableContext(alias, query);
        this.parameters = new ArrayList<SQLParameter>(initialCapacity);
        this.sqlRewriteUnit = sqlRewriteUnit;
        this.invokeCount = 0;
    }

    @Override
    public int expressionInvokeCountGetIncrement() {
        int oldInvokeCount = this.invokeCount++;
        return oldInvokeCount;
    }

    @Override
    public int currentInvokeCount() {
        return this.invokeCount;
    }

    @Override
    public void addParameter(SQLParameter sqlParameter) {
        this.parameters.add(sqlParameter);
    }

    @Override
    public List<SQLParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public SQLRewriteUnit getSQLRewriteUnit() {
        return this.sqlRewriteUnit;
    }

    @Override
    public String getAlias(TableAvailable table) {
        return this.toTableContext.getAlias(table);
    }

    public static ToSQLContext defaultToSQLContext(TableContext tableContext, boolean query) {
        return DefaultToSQLContext.defaultToSQLContext(tableContext, null, query);
    }

    public static ToSQLContext defaultToSQLContext(TableContext tableContext, SQLRewriteUnit sqlRewriteUnit, boolean query) {
        return new DefaultToSQLContext(tableContext, sqlRewriteUnit, query);
    }
}

