/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.parameter;

import com.easy.query.core.basic.jdbc.parameter.BeanSQLParameter;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyBeanUtil;

public final class PropertySQLParameter
implements BeanSQLParameter {
    private final TableAvailable table;
    private final String propertyName;
    private Object bean;

    public PropertySQLParameter(TableAvailable table, String propertyName) {
        this.table = table;
        this.propertyName = propertyName;
    }

    @Override
    public TableAvailable getTableOrNull() {
        return this.table;
    }

    @Override
    public Object getValue() {
        if (this.bean == null) {
            throw new EasyQueryException("cant get sql parameter value," + this.table.getEntityMetadata().getEntityClass() + "." + this.propertyName + ",bean is null");
        }
        EntityMetadata entityMetadata = this.table.getEntityMetadata();
        return EasyBeanUtil.getPropertyValue(this.bean, entityMetadata, this.propertyName);
    }

    @Override
    public void setBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public String getPropertyNameOrNull() {
        return this.propertyName;
    }
}

