/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.tx;

import com.easy.query.core.basic.jdbc.conn.ConnectionManager;
import com.easy.query.core.basic.jdbc.tx.Transaction;
import com.easy.query.core.basic.jdbc.tx.TransactionListener;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class DefaultTransaction
implements Transaction {
    private final Integer isolationLevel;
    private final ConnectionManager connectionManager;
    private boolean open;
    private boolean closed;
    private List<TransactionListener> transactionListeners;

    public DefaultTransaction(Integer isolationLevel, ConnectionManager connectionManager) {
        this.isolationLevel = isolationLevel;
        this.connectionManager = connectionManager;
        this.open = true;
        this.closed = false;
    }

    @Override
    public Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    private void listenerInvoke(Consumer<TransactionListener> consumer) {
        if (EasyCollectionUtil.isNotEmpty(this.transactionListeners)) {
            for (TransactionListener transactionListener : this.transactionListeners) {
                consumer.accept(transactionListener);
            }
        }
    }

    @Override
    public void commit() {
        this.listenerInvoke(TransactionListener::beforeCommit);
        this.connectionManager.commit();
        this.listenerInvoke(TransactionListener::afterCommit);
        this.open = false;
    }

    @Override
    public void rollback() {
        this.listenerInvoke(TransactionListener::beforeRollback);
        this.connectionManager.rollback();
        this.listenerInvoke(TransactionListener::afterRollback);
        this.open = false;
    }

    private void close(boolean closing) {
        if (this.closed) {
            return;
        }
        this.listenerInvoke(TransactionListener::beforeClose);
        if (closing && this.open) {
            this.rollback();
        }
        this.closed = true;
        this.listenerInvoke(TransactionListener::afterClose);
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void registerListener(TransactionListener transactionBehavior) {
        if (this.transactionListeners == null) {
            this.transactionListeners = new ArrayList<TransactionListener>();
        }
        this.transactionListeners.add(transactionBehavior);
    }
}

