/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.types;

import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.handler.BigDecimalTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.BlobTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.BooleanTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.ByteArrayTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.ByteTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.CLobTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.CharArrayTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.DoubleTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.FloatTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.IntegerTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.LocalDateTimeTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.LocalDateTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.LocalTimeTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.LongTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.ObjectTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.SQLDateTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.SQLXMLTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.ShortTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.StringTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.TimeTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.TimestampTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.UUIDTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.UtilDateTypeHandler;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.util.EasyClassUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class EasyJdbcTypeHandlerManager
implements JdbcTypeHandlerManager {
    private static final BigDecimalTypeHandler bigDecimalHandler = new BigDecimalTypeHandler();
    private static final BlobTypeHandler blobTypeHandler = new BlobTypeHandler();
    private static final BooleanTypeHandler booleanDecimalHandler = new BooleanTypeHandler();
    private static final ByteArrayTypeHandler byteArrayTypeHandler = new ByteArrayTypeHandler();
    private static final ByteTypeHandler byteTypeHandler = new ByteTypeHandler();
    private static final CharArrayTypeHandler charArrayTypeHandler = new CharArrayTypeHandler();
    private static final CLobTypeHandler clobTypeHandler = new CLobTypeHandler();
    private static final DoubleTypeHandler doubleTypeHandler = new DoubleTypeHandler();
    private static final FloatTypeHandler floatTypeHandler = new FloatTypeHandler();
    private static final IntegerTypeHandler integerTypeHandler = new IntegerTypeHandler();
    private static final LocalDateTimeTypeHandler localDateTimeHandler = new LocalDateTimeTypeHandler();
    private static final LocalTimeTypeHandler localTimeTypeHandler = new LocalTimeTypeHandler();
    private static final LocalDateTypeHandler localDateHandler = new LocalDateTypeHandler();
    private static final LongTypeHandler longTypeHandler = new LongTypeHandler();
    private static final ShortTypeHandler shortTypeHandler = new ShortTypeHandler();
    private static final SQLDateTypeHandler sqlDateTypeHandler = new SQLDateTypeHandler();
    private static final SQLXMLTypeHandler sqlXMLTypeHandler = new SQLXMLTypeHandler();
    private static final StringTypeHandler stringTypeHandler = new StringTypeHandler();
    private static final UtilDateTypeHandler utilDateTypeHandler = new UtilDateTypeHandler();
    private static final TimestampTypeHandler timestampTypeHandler = new TimestampTypeHandler();
    private static final TimeTypeHandler timeTypeHandler = new TimeTypeHandler();
    private static final JdbcTypeHandler uuidTypeHandler = new UUIDTypeHandler();
    private static final JdbcTypeHandler DEFAULT_HANDLER = new ObjectTypeHandler();
    private static final Map<Class<?>, JdbcTypeHandler> handlers = new ConcurrentHashMap();

    @Override
    public void appendHandler(Class<?> type, JdbcTypeHandler typeHandler, boolean replace) {
        if (handlers.containsKey(type)) {
            if (replace) {
                handlers.put(type, typeHandler);
            }
        } else {
            handlers.put(type, typeHandler);
        }
    }

    @Override
    public JdbcTypeHandler getHandler(Class<?> type) {
        if (type == null) {
            return DEFAULT_HANDLER;
        }
        return handlers.getOrDefault(type, DEFAULT_HANDLER);
    }

    @Override
    public JdbcTypeHandler getHandlerByHandlerClass(Class<?> handlerType) {
        return handlers.values().stream().filter(o -> Objects.equals(o.getClass(), handlerType)).findFirst().orElseThrow(() -> new EasyQueryInvalidOperationException("unknown type handler:" + EasyClassUtil.getSimpleName(handlerType)));
    }

    static {
        handlers.put(BigDecimal.class, bigDecimalHandler);
        handlers.put(Boolean.class, booleanDecimalHandler);
        handlers.put(Boolean.TYPE, booleanDecimalHandler);
        handlers.put(byte[].class, byteArrayTypeHandler);
        handlers.put(Byte.TYPE, byteTypeHandler);
        handlers.put(Byte.class, byteTypeHandler);
        handlers.put(char[].class, charArrayTypeHandler);
        handlers.put(Double.class, doubleTypeHandler);
        handlers.put(Double.TYPE, doubleTypeHandler);
        handlers.put(Float.class, floatTypeHandler);
        handlers.put(Float.TYPE, floatTypeHandler);
        handlers.put(Integer.class, integerTypeHandler);
        handlers.put(Integer.TYPE, integerTypeHandler);
        handlers.put(Long.class, longTypeHandler);
        handlers.put(Long.TYPE, longTypeHandler);
        handlers.put(Short.class, shortTypeHandler);
        handlers.put(Short.TYPE, shortTypeHandler);
        handlers.put(Date.class, sqlDateTypeHandler);
        handlers.put(java.util.Date.class, utilDateTypeHandler);
        handlers.put(SQLXML.class, sqlXMLTypeHandler);
        handlers.put(String.class, stringTypeHandler);
        handlers.put(Timestamp.class, timestampTypeHandler);
        handlers.put(Time.class, timeTypeHandler);
        handlers.put(Clob.class, clobTypeHandler);
        handlers.put(Blob.class, blobTypeHandler);
        handlers.put(LocalDateTime.class, localDateTimeHandler);
        handlers.put(LocalDate.class, localDateHandler);
        handlers.put(LocalTime.class, localTimeTypeHandler);
        handlers.put(UUID.class, uuidTypeHandler);
    }
}

