/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.common.bean;

import com.easy.query.core.common.bean.FastBean;
import com.easy.query.core.common.bean.FastBeanProperty;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.expression.lambda.PropertyVoidSetter;
import com.easy.query.core.util.EasyClassUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class DefaultFastBean
implements FastBean {
    private static final int FLAG_SERIALIZABLE = 1;
    private final Class<?> beanClass;

    public DefaultFastBean(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Property<Object, ?> getBeanGetter(FastBeanProperty prop) {
        return this.getLambdaProperty(prop);
    }

    private Property<Object, ?> getLambdaProperty(FastBeanProperty prop) {
        Class<?> propertyType = prop.getPropertyType();
        Method readMethod = prop.getReadMethod();
        String getFunName = readMethod.getName();
        MethodHandles.Lookup caller = MethodHandles.lookup();
        MethodType methodType = MethodType.methodType(propertyType, this.beanClass);
        try {
            CallSite site = LambdaMetafactory.altMetafactory(caller, "apply", MethodType.methodType(Property.class), methodType.erase().generic(), caller.findVirtual(this.beanClass, getFunName, MethodType.methodType(propertyType)), methodType, 1);
            return site.getTarget().invokeExact();
        }
        catch (Throwable e) {
            throw new EasyQueryException(e);
        }
    }

    @Override
    public PropertySetterCaller<Object> getBeanSetter(FastBeanProperty prop) {
        return this.getLambdaPropertySetter(prop);
    }

    private PropertySetterCaller<Object> getLambdaPropertySetter(FastBeanProperty prop) {
        Class<?> propertyType = prop.getPropertyType();
        MethodHandles.Lookup caller = MethodHandles.lookup();
        Method writeMethod = EasyClassUtil.getWriteMethodNotNull(prop, this.beanClass);
        MethodType setter = MethodType.methodType(writeMethod.getReturnType(), propertyType);
        Class<?> lambdaPropertyType = EasyClassUtil.getObjectTypeWhenPrimitive(propertyType);
        String getFunName = writeMethod.getName();
        try {
            MethodType instantiatedMethodType = MethodType.methodType(Void.TYPE, this.beanClass, lambdaPropertyType);
            MethodHandle target = caller.findVirtual(this.beanClass, getFunName, setter);
            MethodType samMethodType = MethodType.methodType(Void.TYPE, Object.class, Object.class);
            CallSite site = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(PropertyVoidSetter.class), samMethodType, target, instantiatedMethodType);
            PropertyVoidSetter objectPropertyVoidSetter = site.getTarget().invokeExact();
            return objectPropertyVoidSetter::apply;
        }
        catch (Throwable e) {
            throw new EasyQueryException(e);
        }
    }

    @Override
    public Supplier<Object> getBeanConstructorCreator() {
        return this.getLambdaCreate();
    }

    private Supplier<Object> getLambdaCreate() {
        try {
            MethodType constructorType = MethodType.methodType(Void.TYPE);
            MethodHandles.Lookup caller = MethodHandles.lookup();
            MethodHandle constructorHandle = caller.findConstructor(this.beanClass, constructorType);
            CallSite site = LambdaMetafactory.altMetafactory(caller, "get", MethodType.methodType(Supplier.class), constructorHandle.type().generic(), constructorHandle, constructorHandle.type(), 1);
            return site.getTarget().invokeExact();
        }
        catch (Throwable e) {
            throw new EasyQueryException(e);
        }
    }
}

