/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.configuration;

import com.easy.query.core.configuration.EasyQueryReplicaOption;
import com.easy.query.core.configuration.EasyQueryShardingOption;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;

public class EasyQueryOption {
    private final boolean deleteThrowError;
    private final SQLExecuteStrategyEnum insertStrategy;
    private final SQLExecuteStrategyEnum updateStrategy;
    private final int maxShardingQueryLimit;
    private final int executorMaximumPoolSize;
    private final int executorCorePoolSize;
    private final ConnectionModeEnum connectionMode;
    private final boolean throwIfRouteNotMatch;
    private final long shardingExecuteTimeoutMillis;
    private final EasyQueryReplicaOption replicaOption;
    private final EasyQueryShardingOption shardingOption;
    private final String defaultDataSourceName;
    private final int defaultDataSourceMergePoolSize;
    private final boolean queryLargeColumn;
    private final int maxShardingRouteCount;
    private final int executorQueueSize;
    private final long multiConnWaitTimeoutMillis;
    private final boolean warningBusy;
    private final int insertBatchThreshold;
    private final int updateBatchThreshold;
    private final boolean printSql;
    private final boolean startTimeJob;
    private final boolean defaultTrack;
    private final int relationGroupSize;
    private final boolean keepNativeStyle;
    private final long reverseOffsetThreshold;
    private final boolean warningColumnMiss;
    private final int shardingFetchSize;
    private final boolean mapToBeanStrict;
    private final String defaultSchema;

    public EasyQueryOption(boolean deleteThrowError, SQLExecuteStrategyEnum insertStrategy, SQLExecuteStrategyEnum updateStrategy, ConnectionModeEnum connectionMode, int maxShardingQueryLimit, int executorMaximumPoolSize, int executorCorePoolSize, boolean throwIfNotMatchRoute, long shardingExecuteTimeoutMillis, EasyQueryShardingOption shardingOption, EasyQueryReplicaOption replicaOption, String defaultDataSourceName, int defaultDataSourceMergePoolSize, boolean queryLargeColumn, int maxShardingRouteCount, int executorQueueSize, long multiConnWaitTimeoutMillis, boolean warningBusy, int insertBatchThreshold, int updateBatchThreshold, boolean printSql, boolean startTimeJob, boolean defaultTrack, int relationGroupSize, boolean keepNativeStyle, long reverseOffsetThreshold, boolean warningColumnMiss, int shardingFetchSize, boolean mapToBeanStrict, String defaultSchema) {
        if (executorMaximumPoolSize > 0) {
            if (executorCorePoolSize > executorMaximumPoolSize) {
                throw new IllegalArgumentException("Invalid arguments: executorCorePoolSize > executorMaximumPoolSize");
            }
            if (maxShardingQueryLimit > executorMaximumPoolSize) {
                throw new IllegalArgumentException("Invalid arguments: maxShardingQueryLimit > executorMaximumPoolSize");
            }
            if (executorQueueSize <= 0) {
                throw new IllegalArgumentException("Invalid arguments: executorQueueSize <= 0");
            }
            if (executorQueueSize < maxShardingQueryLimit) {
                throw new IllegalArgumentException("Invalid arguments: executorQueueSize < maxShardingQueryLimit");
            }
            if (executorMaximumPoolSize + executorQueueSize < maxShardingQueryLimit) {
                throw new IllegalArgumentException("Invalid arguments: (executorMaximumPoolSize+executorQueueSize) < maxShardingQueryLimit");
            }
        }
        if (shardingExecuteTimeoutMillis <= 0L) {
            throw new IllegalArgumentException("shardingExecuteTimeoutMillis less than zero:" + shardingExecuteTimeoutMillis);
        }
        if (multiConnWaitTimeoutMillis <= 0L) {
            throw new IllegalArgumentException("multiConnWaitTimeoutMillis <= 0");
        }
        if (defaultDataSourceMergePoolSize > 0 && defaultDataSourceMergePoolSize < maxShardingQueryLimit) {
            throw new IllegalArgumentException("invalid arguments: defaultDataSourceMergePoolSize > 0 && defaultDataSourceMergePoolSize < maxShardingQueryLimit.");
        }
        if (insertBatchThreshold <= 2) {
            throw new IllegalArgumentException("invalid arguments: insertBatchThreshold <= 2.");
        }
        if (updateBatchThreshold <= 2) {
            throw new IllegalArgumentException("invalid arguments: updateBatchThreshold <= 2.");
        }
        if (relationGroupSize < 1) {
            throw new IllegalArgumentException("invalid arguments: relationGroupSize < 1.");
        }
        this.deleteThrowError = deleteThrowError;
        this.insertStrategy = SQLExecuteStrategyEnum.getDefaultStrategy(insertStrategy, SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS);
        this.updateStrategy = SQLExecuteStrategyEnum.getDefaultStrategy(updateStrategy, SQLExecuteStrategyEnum.ALL_COLUMNS);
        this.connectionMode = connectionMode;
        this.maxShardingQueryLimit = maxShardingQueryLimit;
        this.executorMaximumPoolSize = executorMaximumPoolSize;
        this.executorCorePoolSize = executorCorePoolSize;
        this.throwIfRouteNotMatch = throwIfNotMatchRoute;
        this.shardingExecuteTimeoutMillis = shardingExecuteTimeoutMillis;
        this.shardingOption = shardingOption;
        this.replicaOption = replicaOption;
        this.defaultDataSourceName = defaultDataSourceName;
        this.defaultDataSourceMergePoolSize = defaultDataSourceMergePoolSize;
        this.queryLargeColumn = queryLargeColumn;
        this.maxShardingRouteCount = maxShardingRouteCount;
        this.executorQueueSize = executorQueueSize;
        this.multiConnWaitTimeoutMillis = multiConnWaitTimeoutMillis;
        this.warningBusy = warningBusy;
        this.insertBatchThreshold = insertBatchThreshold;
        this.updateBatchThreshold = updateBatchThreshold;
        this.printSql = printSql;
        this.startTimeJob = startTimeJob;
        this.defaultTrack = defaultTrack;
        this.relationGroupSize = relationGroupSize;
        this.keepNativeStyle = keepNativeStyle;
        this.reverseOffsetThreshold = reverseOffsetThreshold;
        this.warningColumnMiss = warningColumnMiss;
        this.shardingFetchSize = shardingFetchSize;
        this.mapToBeanStrict = mapToBeanStrict;
        this.defaultSchema = defaultSchema;
    }

    public int getMaxShardingRouteCount() {
        return this.maxShardingRouteCount;
    }

    public boolean isDeleteThrowError() {
        return this.deleteThrowError;
    }

    public SQLExecuteStrategyEnum getInsertStrategy() {
        return this.insertStrategy;
    }

    public SQLExecuteStrategyEnum getUpdateStrategy() {
        return this.updateStrategy;
    }

    public ConnectionModeEnum getConnectionMode() {
        return this.connectionMode;
    }

    public int getMaxShardingQueryLimit() {
        return this.maxShardingQueryLimit;
    }

    public int getExecutorMaximumPoolSize() {
        return this.executorMaximumPoolSize;
    }

    public int getExecutorCorePoolSize() {
        return this.executorCorePoolSize;
    }

    public boolean isThrowIfRouteNotMatch() {
        return this.throwIfRouteNotMatch;
    }

    public long getShardingExecuteTimeoutMillis() {
        return this.shardingExecuteTimeoutMillis;
    }

    public EasyQueryShardingOption getShardingOption() {
        return this.shardingOption;
    }

    public EasyQueryReplicaOption getReplicaOption() {
        return this.replicaOption;
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public boolean isQueryLargeColumn() {
        return this.queryLargeColumn;
    }

    public int getExecutorQueueSize() {
        return this.executorQueueSize;
    }

    public int getDefaultDataSourceMergePoolSize() {
        return this.defaultDataSourceMergePoolSize;
    }

    public long getMultiConnWaitTimeoutMillis() {
        return this.multiConnWaitTimeoutMillis;
    }

    public boolean isWarningBusy() {
        return this.warningBusy;
    }

    public int getInsertBatchThreshold() {
        return this.insertBatchThreshold;
    }

    public int getUpdateBatchThreshold() {
        return this.updateBatchThreshold;
    }

    public boolean isPrintSql() {
        return this.printSql;
    }

    public boolean isStartTimeJob() {
        return this.startTimeJob;
    }

    public boolean isDefaultTrack() {
        return this.defaultTrack;
    }

    public int getRelationGroupSize() {
        return this.relationGroupSize;
    }

    public boolean isKeepNativeStyle() {
        return this.keepNativeStyle;
    }

    public boolean enableReverseOrder(long offset) {
        if (this.reverseOffsetThreshold <= 0L) {
            return false;
        }
        return offset >= this.reverseOffsetThreshold;
    }

    public boolean isWarningColumnMiss() {
        return this.warningColumnMiss;
    }

    public int getShardingFetchSize() {
        return this.shardingFetchSize;
    }

    public boolean isMapToBeanStrict() {
        return this.mapToBeanStrict;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }
}

