/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.datasource;

import com.easy.query.core.basic.jdbc.conn.DataSourceWrapper;
import com.easy.query.core.basic.jdbc.conn.impl.DefaultDataSourceWrapper;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.configuration.EasyQueryShardingOption;
import com.easy.query.core.configuration.ShardingDataSource;
import com.easy.query.core.datasource.DataSourceManager;
import com.easy.query.core.datasource.DataSourceUnit;
import com.easy.query.core.datasource.DataSourceUnitFactory;
import com.easy.query.core.enums.conn.ConnectionStrategyEnum;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DefaultDataSourceManager
implements DataSourceManager {
    protected final String defaultDataSourceName;
    protected final DataSource defaultDataSource;
    protected final DataSourceUnitFactory dataSourceUnitFactory;
    protected final Map<String, DataSourceUnit> dataSourceMap = new ConcurrentHashMap<String, DataSourceUnit>();

    public DefaultDataSourceManager(EasyQueryOption easyQueryOption, DataSource defaultDataSource, DataSourceUnitFactory dataSourceUnitFactory) {
        this.defaultDataSourceName = easyQueryOption.getDefaultDataSourceName();
        this.defaultDataSource = defaultDataSource;
        this.dataSourceUnitFactory = dataSourceUnitFactory;
        this.dataSourceMap.putIfAbsent(this.defaultDataSourceName, dataSourceUnitFactory.createDataSourceUnit(this.defaultDataSourceName, defaultDataSource, easyQueryOption.getDefaultDataSourceMergePoolSize()));
        this.initShardingConfig(easyQueryOption);
    }

    private void initShardingConfig(EasyQueryOption easyQueryOption) {
        Set<ShardingDataSource> shardingDataSources;
        EasyQueryShardingOption shardingOption = easyQueryOption.getShardingOption();
        if (shardingOption != null && (shardingDataSources = shardingOption.getShardingDataSources()) != null) {
            for (ShardingDataSource shardingDataSource : shardingDataSources) {
                this.dataSourceMap.putIfAbsent(shardingDataSource.getDataSourceName(), this.dataSourceUnitFactory.createDataSourceUnit(shardingDataSource.getDataSourceName(), shardingDataSource.getDataSource(), shardingDataSource.getDataSourceMergePoolSize()));
            }
        }
    }

    @Override
    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    @Override
    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    @Override
    public boolean addDataSource(String dataSourceName, DataSource dataSource, int dataSourcePoolSize) {
        return this.dataSourceMap.putIfAbsent(dataSourceName, this.dataSourceUnitFactory.createDataSourceUnit(dataSourceName, dataSource, dataSourcePoolSize)) == null;
    }

    @Override
    public Map<String, DataSourceUnit> getAllDataSource() {
        return this.dataSourceMap;
    }

    @Override
    public DataSourceWrapper getDataSourceOrNull(String dataSourceName, ConnectionStrategyEnum connectionStrategy) {
        if (dataSourceName == null) {
            throw new IllegalArgumentException("dataSourceName");
        }
        DataSourceUnit dataSource = this.dataSourceMap.get(dataSourceName);
        return new DefaultDataSourceWrapper(dataSource, connectionStrategy);
    }
}

