/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.datasource.replica;

import com.easy.query.core.basic.jdbc.conn.DataSourceWrapper;
import com.easy.query.core.basic.jdbc.conn.impl.DefaultDataSourceWrapper;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.configuration.EasyQueryReplicaOption;
import com.easy.query.core.configuration.ShardingDataSource;
import com.easy.query.core.datasource.DataSourceUnit;
import com.easy.query.core.datasource.DataSourceUnitFactory;
import com.easy.query.core.datasource.DefaultDataSourceManager;
import com.easy.query.core.datasource.replica.ReplicaDataSourceManager;
import com.easy.query.core.datasource.replica.ReplicaNode;
import com.easy.query.core.datasource.replica.connectors.AbstractAliasReplicaConnector;
import com.easy.query.core.datasource.replica.connectors.LoopReplicaConnector;
import com.easy.query.core.datasource.replica.connectors.RandomReplicaConnector;
import com.easy.query.core.datasource.replica.connectors.ReplicaConnector;
import com.easy.query.core.enums.conn.ConnectionStrategyEnum;
import com.easy.query.core.enums.replica.ReplicaUseStrategyEnum;
import com.easy.query.core.util.EasyMapUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public final class DefaultReplicaDataSourceManager
extends DefaultDataSourceManager
implements ReplicaDataSourceManager {
    private final Map<String, ReplicaConnector> replicaDataSource = new ConcurrentHashMap<String, ReplicaConnector>();
    private final EasyQueryOption easyQueryOption;

    public DefaultReplicaDataSourceManager(EasyQueryOption easyQueryOption, DataSource defaultDataSource, DataSourceUnitFactory dataSourceUnitFactory) {
        super(easyQueryOption, defaultDataSource, dataSourceUnitFactory);
        this.easyQueryOption = easyQueryOption;
        EasyQueryReplicaOption replicaOption = easyQueryOption.getReplicaOption();
        if (replicaOption == null) {
            throw new IllegalArgumentException("replica data source manager cant use empty replica");
        }
        this.initReplicaConnector(replicaOption);
    }

    private void initReplicaConnector(EasyQueryReplicaOption replicaOption) {
        Map<String, Map<String, ShardingDataSource>> replicaConfig = replicaOption.getReplicaConfig();
        for (Map.Entry<String, Map<String, ShardingDataSource>> dataSourceMap : replicaConfig.entrySet()) {
            String dataSource = dataSourceMap.getKey();
            Set<Map.Entry<String, ShardingDataSource>> entries = dataSourceMap.getValue().entrySet();
            ArrayList<ReplicaNode> replicaNodes = new ArrayList<ReplicaNode>(entries.size());
            for (Map.Entry<String, ShardingDataSource> replicaKv : entries) {
                ShardingDataSource shardingDataSource = replicaKv.getValue();
                replicaNodes.add(new ReplicaNode(replicaKv.getKey(), this.dataSourceUnitFactory.createDataSourceUnit(shardingDataSource.getDataSourceName(), shardingDataSource.getDataSource(), shardingDataSource.getDataSourceMergePoolSize())));
            }
            AbstractAliasReplicaConnector replicaConnector = Objects.equals((Object)ReplicaUseStrategyEnum.Loop, (Object)replicaOption.getReplicaUseStrategy()) ? new LoopReplicaConnector(dataSource, replicaNodes) : new RandomReplicaConnector(dataSource, replicaNodes);
            this.replicaDataSource.put(dataSource, replicaConnector);
        }
    }

    private ReplicaConnector createEmptyReplicaConnector(String dataSourceName) {
        return Objects.equals((Object)ReplicaUseStrategyEnum.Loop, (Object)this.easyQueryOption.getReplicaOption().getReplicaUseStrategy()) ? new LoopReplicaConnector(dataSourceName, new ArrayList<ReplicaNode>()) : new RandomReplicaConnector(dataSourceName, new ArrayList<ReplicaNode>());
    }

    @Override
    public boolean addDataSource(String dataSourceName, String replicaAlias, DataSource dataSource, int dataSourcePoolSize) {
        ReplicaConnector replicaConnector = EasyMapUtil.computeIfAbsent(this.replicaDataSource, dataSourceName, k -> this.createEmptyReplicaConnector(dataSourceName));
        DataSourceUnit dataSourceUnit = this.dataSourceUnitFactory.createDataSourceUnit(dataSourceName, dataSource, dataSourcePoolSize);
        return replicaConnector.addReplicaNode(new ReplicaNode(replicaAlias, dataSourceUnit));
    }

    @Override
    public DataSourceUnit getDataSourceOrNull(String dataSourceName, String replicaAlias) {
        ReplicaConnector replicaConnector = this.replicaDataSource.get(dataSourceName);
        if (replicaConnector != null) {
            return replicaConnector.getDataSourceOrNull(replicaAlias);
        }
        return null;
    }

    @Override
    public DataSourceWrapper getDataSourceOrNull(String dataSourceName, ConnectionStrategyEnum connectionStrategy) {
        if (Objects.equals((Object)ConnectionStrategyEnum.IndependentConnectionReplica, (Object)connectionStrategy)) {
            DataSourceUnit dataSourceUnit;
            ReplicaConnector replicaConnector = this.replicaDataSource.get(dataSourceName);
            if (replicaConnector != null && (dataSourceUnit = replicaConnector.getDataSourceOrNull(null)) != null) {
                return new DefaultDataSourceWrapper(dataSourceUnit, connectionStrategy);
            }
            return super.getDataSourceOrNull(dataSourceName, ConnectionStrategyEnum.IndependentConnectionMaster);
        }
        return super.getDataSourceOrNull(dataSourceName, connectionStrategy);
    }
}

