/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.builder.impl;

import com.easy.query.core.basic.api.select.Query;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EntityMetadataTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.core.ResultColumnInfo;
import com.easy.query.core.expression.builder.impl.AbstractSelector;
import com.easy.query.core.expression.func.ColumnFunction;
import com.easy.query.core.expression.func.ColumnPropertyFunction;
import com.easy.query.core.expression.lambda.SQLActionExpression;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.lambda.SQLFuncExpression;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.scec.core.SQLNativeChainExpressionContextImpl;
import com.easy.query.core.expression.segment.CloneableSQLSegment;
import com.easy.query.core.expression.segment.ColumnSegment;
import com.easy.query.core.expression.segment.FuncColumnSegment;
import com.easy.query.core.expression.segment.SQLNativeSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.SubQueryColumnSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.impl.SQLFunctionColumnSegmentImpl;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContext;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContextImpl;
import com.easy.query.core.expression.sql.builder.AnonymousEntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.SQLFunctionTranslateImpl;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyStringUtil;
import java.util.Collection;
import java.util.Objects;

public class AsSelectorImpl
extends AbstractSelector<AsSelector>
implements AsSelector {
    private final EntityQueryExpressionBuilder entityQueryExpressionBuilder;
    protected final Class<?> resultClass;
    protected final EntityMetadata resultEntityMetadata;

    public AsSelectorImpl(EntityQueryExpressionBuilder entityQueryExpressionBuilder, SQLBuilderSegment sqlBuilderSegment, Class<?> resultClass) {
        super(entityQueryExpressionBuilder, sqlBuilderSegment);
        this.entityQueryExpressionBuilder = entityQueryExpressionBuilder;
        this.resultClass = resultClass;
        this.resultEntityMetadata = this.runtimeContext.getEntityMetadataManager().getEntityMetadata(resultClass);
    }

    @Override
    protected ResultColumnInfo getResultColumnName(String propertyAlias) {
        switch (this.resultEntityMetadata.getEntityMetadataType()) {
            case MAP: 
            case BASIC_TYPE: {
                return new ResultColumnInfo(null, propertyAlias);
            }
        }
        ColumnMetadata columnMetadata = this.resultEntityMetadata.getColumnNotNull(propertyAlias);
        return new ResultColumnInfo(columnMetadata, columnMetadata.getName());
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public AsSelector groupKeys(int index) {
        return (AsSelector)this.groupKeysAs(index, null);
    }

    @Override
    public AsSelector columnAs(TableAvailable table, String property, String propertyAlias) {
        ResultColumnInfo resultColumnInfo = this.getResultColumnName(propertyAlias);
        ColumnSegment columnSegment = this.sqlSegmentFactory.createColumnSegment(table, property, this.expressionContext, resultColumnInfo.getColumnAsName());
        this.sqlBuilderSegment.append(columnSegment);
        return this;
    }

    public <T2> void extract(Query<T2> subQuery) {
        EntityQueryExpressionBuilder subQueryableSQLEntityExpressionBuilder = subQuery.getSQLEntityExpressionBuilder();
        this.expressionContext.extract(subQueryableSQLEntityExpressionBuilder.getExpressionContext());
    }

    @Override
    public <TSubQuery> AsSelector columnSubQueryAs(SQLFuncExpression<Query<TSubQuery>> subQueryableFunc, String propertyAlias) {
        Query<TSubQuery> subQuery = subQueryableFunc.apply();
        this.extract(subQuery);
        ResultColumnInfo resultColumnInfo = this.getResultColumnName(propertyAlias);
        SubQueryColumnSegment subQueryColumnSegment = this.sqlSegmentFactory.createSubQueryColumnSegment(null, subQuery, resultColumnInfo.getColumnAsName(), this.runtimeContext);
        this.sqlBuilderSegment.append(subQueryColumnSegment);
        return this;
    }

    @Override
    public AsSelector sqlNativeSegment(String sqlSegment, SQLExpression1<SQLNativeExpressionContext> contextConsume) {
        Objects.requireNonNull(contextConsume, "sql native context consume cannot be null");
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        sqlNativeExpressionContext.setResultEntityMetadata(this.resultEntityMetadata);
        contextConsume.apply(sqlNativeExpressionContext);
        SQLNativeSegment columnSegment = this.sqlSegmentFactory.createSQLNativeSegment(this.expressionContext, sqlSegment, sqlNativeExpressionContext);
        this.sqlBuilderSegment.append(columnSegment);
        return this.castChain();
    }

    @Override
    protected AsSelector castChain() {
        return this;
    }

    @Override
    public AsSelector columnAll(TableAvailable table) {
        if (table.getEntityClass().equals(this.resultClass) || this.resultEntityMetadata.getEntityMetadataType() == EntityMetadataTypeEnum.MAP) {
            super.columnAll(table);
            return this;
        }
        EntityTableExpressionBuilder tableBuilder = this.getTableExpressionBuilderByTable(table);
        return this.columnAll(tableBuilder);
    }

    private AsSelector columnAll(EntityTableExpressionBuilder tableBuilder) {
        if (tableBuilder instanceof AnonymousEntityTableExpressionBuilder) {
            this.columnAnonymousAll((AnonymousEntityTableExpressionBuilder)tableBuilder);
        } else {
            EntityMetadata entityMetadata = tableBuilder.getEntityMetadata();
            Collection<ColumnMetadata> columns = entityMetadata.getColumns();
            for (ColumnMetadata columnMetadata : columns) {
                String columnName = columnMetadata.getName();
                String aliasPropertyName = this.resultEntityMetadata.getPropertyNameOrNull(columnName);
                if (aliasPropertyName == null) continue;
                ColumnMetadata resultColumnMetadata = this.resultEntityMetadata.getColumnNotNull(aliasPropertyName);
                String aliasColumnName = resultColumnMetadata.getName();
                String alias = Objects.equals(columnName, aliasColumnName) ? null : aliasColumnName;
                ColumnSegment columnSegment = this.sqlSegmentFactory.createColumnSegment(tableBuilder.getEntityTable(), columnMetadata.getPropertyName(), this.expressionContext, alias);
                this.sqlBuilderSegment.append(columnSegment);
            }
            this.autoColumnInclude(tableBuilder.getEntityTable(), entityMetadata);
        }
        return this;
    }

    @Override
    public AsSelector columnFuncAs(TableAvailable table, ColumnPropertyFunction columnPropertyFunction, String propertyAlias) {
        String propertyName = columnPropertyFunction.getPropertyName();
        ColumnFunction columnFunction = columnPropertyFunction.getColumnFunction();
        String columnAsName = propertyAlias == null ? table.getColumnName(propertyName) : this.getResultColumnName(propertyAlias).getColumnAsName();
        FuncColumnSegment funcColumnSegment = this.sqlSegmentFactory.createFuncColumnSegment(table, propertyName, this.expressionContext, columnFunction, columnAsName);
        this.sqlBuilderSegment.append(funcColumnSegment);
        return this;
    }

    @Override
    public AsSelector columnFunc(TableAvailable table, String property, SQLFunction sqlFunction, String propertyAlias, SQLActionExpression sqlActionExpression) {
        if (table == null || property == null) {
            if (EasyStringUtil.isBlank(propertyAlias)) {
                throw new EasyQueryInvalidOperationException("propertyAlias is bank");
            }
            ResultColumnInfo resultColumnInfo = this.getResultColumnName(propertyAlias);
            SQLSegment sqlSegment = new SQLFunctionTranslateImpl(sqlFunction).toSQLSegment(this.expressionContext, table, this.runtimeContext, resultColumnInfo.getColumnAsName());
            SQLFunctionColumnSegmentImpl funcColumnSegment = new SQLFunctionColumnSegmentImpl(table, resultColumnInfo.getColumnMetadata(), this.runtimeContext, sqlSegment, sqlFunction.getAggregationType(), resultColumnInfo.getColumnAsName());
            this.sqlBuilderSegment.append(funcColumnSegment);
            sqlActionExpression.apply();
            return this;
        }
        ColumnMetadata columnMetadata = table.getEntityMetadata().getColumnNotNull(property);
        String columnAsName = propertyAlias == null ? columnMetadata.getName() : this.getResultColumnName(propertyAlias).getColumnAsName();
        SQLSegment sqlSegment = new SQLFunctionTranslateImpl(sqlFunction).toSQLSegment(this.expressionContext, table, this.runtimeContext, columnAsName);
        SQLFunctionColumnSegmentImpl funcColumnSegment = new SQLFunctionColumnSegmentImpl(table, columnMetadata, this.runtimeContext, sqlSegment, sqlFunction.getAggregationType(), columnAsName);
        this.sqlBuilderSegment.append(funcColumnSegment);
        sqlActionExpression.apply();
        return this;
    }

    @Override
    public AsSelector columnFunc(TableAvailable table, SQLFunction sqlFunction, String propertyAlias) {
        if (propertyAlias == null) {
            SQLSegment sqlSegment = new SQLFunctionTranslateImpl(sqlFunction).toSQLSegment(this.expressionContext, table, this.runtimeContext, null);
            SQLFunctionColumnSegmentImpl funcColumnSegment = new SQLFunctionColumnSegmentImpl(table, null, this.runtimeContext, sqlSegment, sqlFunction.getAggregationType(), null);
            this.sqlBuilderSegment.append(funcColumnSegment);
        } else {
            ResultColumnInfo resultColumnInfo = this.getResultColumnName(propertyAlias);
            SQLSegment sqlSegment = new SQLFunctionTranslateImpl(sqlFunction).toSQLSegment(this.expressionContext, table, this.runtimeContext, resultColumnInfo.getColumnAsName());
            SQLFunctionColumnSegmentImpl funcColumnSegment = new SQLFunctionColumnSegmentImpl(table, resultColumnInfo.getColumnMetadata(), this.runtimeContext, sqlSegment, sqlFunction.getAggregationType(), resultColumnInfo.getColumnAsName());
            this.sqlBuilderSegment.append(funcColumnSegment);
        }
        return this;
    }

    @Override
    public AsSelector sqlSegmentAs(CloneableSQLSegment sqlColumnSegment, String propertyAlias) {
        String columnAsName = propertyAlias == null ? null : this.getResultColumnName(propertyAlias).getColumnAsName();
        CloneableSQLSegment sqlColumnAsSegment = this.sqlSegmentFactory.createSQLColumnAsSegment(sqlColumnSegment, columnAsName, this.runtimeContext);
        this.sqlBuilderSegment.append(sqlColumnAsSegment);
        return this;
    }

    @Override
    public AsSelector sqlFunc(TableAvailable table, SQLFunction sqlFunction) {
        String sqlSegment = sqlFunction.sqlSegment(table);
        this.sqlNativeSegment(sqlSegment, context -> sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, (SQLNativeExpressionContext)context)));
        return this;
    }
}

