/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.builder.impl;

import com.easy.query.core.basic.api.select.Query;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.SQLLikeEnum;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.enums.SQLRangeEnum;
import com.easy.query.core.expression.builder.Filter;
import com.easy.query.core.expression.builder.core.ValueFilter;
import com.easy.query.core.expression.func.ColumnFunction;
import com.easy.query.core.expression.func.ColumnPropertyFunction;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.scec.core.SQLNativeChainExpressionContextImpl;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.OrPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.ColumnCollectionPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnExistsSubQueryPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnInSubQueryPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnNoneSubQueryPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnNullAssertPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnTrueOrFalsePredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnValuePredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnWithColumnPredicate;
import com.easy.query.core.expression.segment.condition.predicate.FuncColumnValuePredicate;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.SQLNativePredicateImpl;
import com.easy.query.core.expression.segment.condition.predicate.SQLNativesPredicateImpl;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContext;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContextImpl;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class FilterImpl
implements Filter {
    private final QueryRuntimeContext runtimeContext;
    private final ExpressionContext expressionContext;
    private final PredicateSegment rootPredicateSegment;
    private final boolean reverse;
    private final ValueFilter conditionAcceptAssert;
    private PredicateSegment nextPredicateSegment;

    public FilterImpl(QueryRuntimeContext runtimeContext, ExpressionContext expressionContext, PredicateSegment predicateSegment, boolean reverse, ValueFilter conditionAcceptAssert) {
        this.runtimeContext = runtimeContext;
        this.expressionContext = expressionContext;
        this.rootPredicateSegment = predicateSegment;
        this.reverse = reverse;
        this.conditionAcceptAssert = conditionAcceptAssert;
        this.nextPredicateSegment = new AndPredicateSegment();
    }

    protected void nextAnd() {
        if (this.nextPredicateSegment.isNotEmpty()) {
            this.rootPredicateSegment.addPredicateSegment(this.nextPredicateSegment);
        }
        this.nextPredicateSegment = new AndPredicateSegment();
    }

    protected void nextOr() {
        if (this.nextPredicateSegment.isNotEmpty()) {
            this.rootPredicateSegment.addPredicateSegment(this.nextPredicateSegment);
        }
        this.nextPredicateSegment = new OrPredicateSegment();
    }

    protected void next() {
        if (this.reverse) {
            this.nextOr();
        } else {
            this.nextAnd();
        }
    }

    private boolean conditionAppend(TableAvailable table, String property, Object value) {
        return this.conditionAcceptAssert.accept(table, property, value);
    }

    protected SQLPredicateCompare getReallyPredicateCompare(SQLPredicateCompare sqlPredicateCompare) {
        return this.reverse ? sqlPredicateCompare.toReverse() : sqlPredicateCompare;
    }

    protected void appendThisPredicate(TableAvailable table, String property, Object val, SQLPredicateCompare condition) {
        ColumnMetadata columnMetadata = table.getEntityMetadata().getColumnNotNull(property);
        this.nextPredicateSegment.setPredicate(new ColumnValuePredicate(table, columnMetadata, val, this.getReallyPredicateCompare(condition), this.expressionContext));
    }

    protected void appendThisFuncPredicate(TableAvailable table, String propertyName, ColumnFunction func, SQLPredicateCompare compare, Object val) {
        this.nextPredicateSegment.setPredicate(new FuncColumnValuePredicate(table, func, propertyName, val, compare, this.expressionContext));
    }

    @Override
    public boolean getReverse() {
        return this.reverse;
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public Filter gt(TableAvailable table, String property, Object val) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, val, SQLPredicateCompareEnum.GT);
            this.next();
        }
        return this;
    }

    @Override
    public Filter ge(TableAvailable table, String property, Object val) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, val, SQLPredicateCompareEnum.GE);
            this.next();
        }
        return this;
    }

    @Override
    public Filter eq(TableAvailable table, String property, Object val) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, val, SQLPredicateCompareEnum.EQ);
            this.next();
        }
        return this;
    }

    @Override
    public Filter ne(TableAvailable table, String property, Object val) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, val, SQLPredicateCompareEnum.NE);
            this.next();
        }
        return this;
    }

    @Override
    public Filter le(TableAvailable table, String property, Object val) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, val, SQLPredicateCompareEnum.LE);
            this.next();
        }
        return this;
    }

    @Override
    public Filter lt(TableAvailable table, String property, Object val) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, val, SQLPredicateCompareEnum.LT);
            this.next();
        }
        return this;
    }

    @Override
    public Filter like(TableAvailable table, String property, Object val, SQLLikeEnum sqlLike) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, EasySQLUtil.getLikeParameter(val, sqlLike), SQLPredicateCompareEnum.LIKE);
            this.next();
        }
        return this;
    }

    @Override
    public Filter likeRaw(TableAvailable table, String property, Object val, SQLLikeEnum sqlLike) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, EasySQLUtil.getLikeRawParameter(val, sqlLike), SQLPredicateCompareEnum.LIKE);
            this.next();
        }
        return this;
    }

    @Override
    public Filter notLikeRaw(TableAvailable table, String property, Object val, SQLLikeEnum sqlLike) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, EasySQLUtil.getLikeRawParameter(val, sqlLike), SQLPredicateCompareEnum.NOT_LIKE);
            this.next();
        }
        return this;
    }

    @Override
    public Filter notLike(TableAvailable table, String property, Object val, SQLLikeEnum sqlLike) {
        if (this.conditionAppend(table, property, val)) {
            this.appendThisPredicate(table, property, EasySQLUtil.getLikeParameter(val, sqlLike), SQLPredicateCompareEnum.NOT_LIKE);
            this.next();
        }
        return this;
    }

    @Override
    public Filter isNull(TableAvailable table, String property) {
        this.nextPredicateSegment.setPredicate(new ColumnNullAssertPredicate(table, property, this.getReallyPredicateCompare(SQLPredicateCompareEnum.IS_NULL), this.expressionContext));
        this.next();
        return this;
    }

    @Override
    public Filter isNotNull(TableAvailable table, String property) {
        this.nextPredicateSegment.setPredicate(new ColumnNullAssertPredicate(table, property, this.getReallyPredicateCompare(SQLPredicateCompareEnum.IS_NOT_NULL), this.expressionContext));
        this.next();
        return this;
    }

    @Override
    public Filter isNull(TableAvailable table, SQLFunction sqlFunction) {
        return this.assertSQLFunction(table, sqlFunction, SQLPredicateCompareEnum.IS_NULL);
    }

    @Override
    public Filter isNotNull(TableAvailable table, SQLFunction sqlFunction) {
        return this.assertSQLFunction(table, sqlFunction, SQLPredicateCompareEnum.IS_NOT_NULL);
    }

    private Filter assertSQLFunction(TableAvailable table, SQLFunction sqlFunction, SQLPredicateCompare sqlPredicateAssert) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        String sqlSegment = sqlFunction.sqlSegment(table);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + sqlPredicateAssert.getSQL(), sqlNativeExpressionContext));
        this.next();
        return this;
    }

    @Override
    public Filter in(TableAvailable table, String property, Collection<?> collection) {
        if (this.conditionAppend(table, property, collection)) {
            this.nextPredicateSegment.setPredicate(new ColumnCollectionPredicate(table, property, collection, this.getReallyPredicateCompare(SQLPredicateCompareEnum.IN), this.expressionContext));
            this.next();
        }
        return this;
    }

    @Override
    public <TProperty> Filter in(TableAvailable table, String property, TProperty[] collection) {
        if (this.conditionAppend(table, property, collection)) {
            this.nextPredicateSegment.setPredicate(new ColumnCollectionPredicate(table, property, Arrays.asList(collection), this.getReallyPredicateCompare(SQLPredicateCompareEnum.IN), this.expressionContext));
            this.next();
        }
        return this;
    }

    private <T2> void extract(Query<T2> subQuery) {
        EntityQueryExpressionBuilder subQueryableSQLEntityExpressionBuilder = subQuery.getSQLEntityExpressionBuilder();
        this.expressionContext.extract(subQueryableSQLEntityExpressionBuilder.getExpressionContext());
    }

    private <TProperty> void subQueryFilter0(TableAvailable table, String property, Query<TProperty> subQueryable, SQLPredicateCompare sqlPredicateCompare) {
        Query<TProperty> tPropertyQuery = subQueryable.cloneQueryable();
        this.extract(tPropertyQuery);
        this.nextPredicateSegment.setPredicate(new ColumnInSubQueryPredicate(table, property, tPropertyQuery, this.getReallyPredicateCompare(sqlPredicateCompare), this.expressionContext));
        this.next();
    }

    private void funcValueFilter0(TableAvailable table, SQLFunction sqlFunction, Object val, SQLPredicateCompare sqlPredicateCompare) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLPredicateCompare predicateCompare = this.getReallyPredicateCompare(sqlPredicateCompare);
        String sqlSegment = sqlFunction.sqlSegment(table);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        sqlNativeExpressionContext.value(val);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + predicateCompare.getSQL() + " {" + sqlFunction.paramMarks() + "}", sqlNativeExpressionContext));
        this.next();
    }

    private void funcColumnFilter0(TableAvailable table1, SQLFunction sqlFunction, TableAvailable table2, String property, SQLPredicateCompare sqlPredicateCompare) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLPredicateCompare predicateCompare = this.getReallyPredicateCompare(sqlPredicateCompare);
        String sqlSegment = sqlFunction.sqlSegment(table1);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table1, sqlNativeExpressionContext));
        sqlNativeExpressionContext.expression(table2, property);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + predicateCompare.getSQL() + " {" + sqlFunction.paramMarks() + "}", sqlNativeExpressionContext));
        this.next();
    }

    private <TProperty> void funcSubQueryFilter0(TableAvailable table1, SQLFunction sqlFunction, Query<TProperty> subQuery, SQLPredicateCompare sqlPredicateCompare) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLPredicateCompare predicateCompare = this.getReallyPredicateCompare(sqlPredicateCompare);
        String sqlSegment = sqlFunction.sqlSegment(table1);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table1, sqlNativeExpressionContext));
        sqlNativeExpressionContext.expression(subQuery.cloneQueryable());
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + predicateCompare.getSQL() + " {" + sqlFunction.paramMarks() + "}", sqlNativeExpressionContext));
        this.next();
    }

    private <TProperty> void funcInFilter0(TableAvailable table, SQLFunction sqlFunction, Collection<TProperty> collections, SQLPredicateCompare sqlPredicateCompare) {
        SQLPredicateCompare predicateCompare = this.getReallyPredicateCompare(sqlPredicateCompare);
        if (EasyCollectionUtil.isEmpty(collections)) {
            if (SQLPredicateCompareEnum.IN == predicateCompare) {
                this.nextPredicateSegment.setPredicate(new ColumnTrueOrFalsePredicate(false, sqlPredicateCompare, table));
                this.next();
                return;
            }
            if (SQLPredicateCompareEnum.NOT_IN == predicateCompare) {
                this.nextPredicateSegment.setPredicate(new ColumnTrueOrFalsePredicate(true, sqlPredicateCompare, table));
                this.next();
                return;
            }
            throw new UnsupportedOperationException();
        }
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        String sqlSegment = sqlFunction.sqlSegment(table);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        sqlNativeExpressionContext.collection(collections);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + predicateCompare.getSQL() + " ({" + sqlFunction.paramMarks() + "})", sqlNativeExpressionContext));
        this.next();
    }

    private void valueFuncFilter0(TableAvailable table, String property, TableAvailable tableRight, SQLFunction sqlFunction, SQLPredicateCompare sqlPredicateCompare) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLPredicateCompare predicateCompare = this.getReallyPredicateCompare(sqlPredicateCompare);
        String sqlSegment = sqlFunction.sqlSegment(tableRight);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        sqlNativeExpressionContext.expression(table, property);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, " {" + sqlFunction.paramMarks() + "} " + predicateCompare.getSQL() + " " + sqlSegment, sqlNativeExpressionContext));
        this.next();
    }

    private void funcColumnFuncFilter0(TableAvailable tableLeft, SQLFunction sqlFunctionLeft, TableAvailable tableRight, SQLFunction sqlFunctionRight, SQLPredicateCompare sqlPredicateCompare) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContextLeft = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        sqlFunctionLeft.consume(new SQLNativeChainExpressionContextImpl(tableLeft, sqlNativeExpressionContextLeft));
        SQLNativeExpressionContextImpl sqlNativeExpressionContextRight = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        sqlFunctionRight.consume(new SQLNativeChainExpressionContextImpl(tableRight, sqlNativeExpressionContextRight));
        SQLPredicateCompare predicateCompare = this.getReallyPredicateCompare(sqlPredicateCompare);
        Predicate sqlNativePredicateLeft = EasySQLExpressionUtil.getSQLFunctionPredicate(this.expressionContext, tableLeft, sqlFunctionLeft, sqlNativeExpressionContextLeft);
        Predicate sqlNativePredicateRight = EasySQLExpressionUtil.getSQLFunctionPredicate(this.expressionContext, tableRight, sqlFunctionRight, sqlNativeExpressionContextRight);
        this.nextPredicateSegment.setPredicate(new SQLNativesPredicateImpl(this.runtimeContext, sqlNativePredicateLeft, predicateCompare, sqlNativePredicateRight));
        this.next();
    }

    private <T2> void subQueryExists(Query<T2> subQuery, SQLPredicateCompareEnum sqlPredicateCompare) {
        this.extract(subQuery);
        Query<T2> existsQuery = subQuery.cloneQueryable().select("1");
        this.nextPredicateSegment.setPredicate(new ColumnExistsSubQueryPredicate(existsQuery, this.getReallyPredicateCompare(sqlPredicateCompare), this.runtimeContext));
        this.next();
    }

    private <T2> void subQueryNone(Query<T2> subQuery) {
        this.extract(subQuery);
        Query<T2> noneQuery = subQuery.cloneQueryable().select("1");
        this.nextPredicateSegment.setPredicate(new ColumnNoneSubQueryPredicate(noneQuery, this.runtimeContext));
        this.next();
    }

    @Override
    public <TProperty> Filter in(TableAvailable table, String property, Query<TProperty> subQuery) {
        if (this.conditionAppend(table, property, subQuery)) {
            this.subQueryFilter0(table, property, subQuery, SQLPredicateCompareEnum.IN);
        }
        return this;
    }

    @Override
    public Filter notIn(TableAvailable table, String property, Collection<?> collection) {
        if (this.conditionAppend(table, property, collection)) {
            this.nextPredicateSegment.setPredicate(new ColumnCollectionPredicate(table, property, collection, this.getReallyPredicateCompare(SQLPredicateCompareEnum.NOT_IN), this.expressionContext));
            this.next();
        }
        return this;
    }

    @Override
    public <TProperty> Filter notIn(TableAvailable table, String property, TProperty[] collection) {
        if (this.conditionAppend(table, property, collection)) {
            this.nextPredicateSegment.setPredicate(new ColumnCollectionPredicate(table, property, Arrays.asList(collection), this.getReallyPredicateCompare(SQLPredicateCompareEnum.NOT_IN), this.expressionContext));
            this.next();
        }
        return this;
    }

    @Override
    public <TProperty> Filter notIn(TableAvailable table, String property, Query<TProperty> subQuery) {
        if (this.conditionAppend(table, property, subQuery)) {
            this.subQueryFilter0(table, property, subQuery, SQLPredicateCompareEnum.NOT_IN);
        }
        return this;
    }

    @Override
    public <T2> Filter exists(Query<T2> subQuery) {
        if (this.conditionAppend(null, null, subQuery)) {
            this.subQueryExists(subQuery, SQLPredicateCompareEnum.EXISTS);
        }
        return this;
    }

    @Override
    public <T2> Filter notExists(Query<T2> subQuery) {
        if (this.conditionAppend(null, null, subQuery)) {
            this.subQueryExists(subQuery, SQLPredicateCompareEnum.NOT_EXISTS);
        }
        return this;
    }

    @Override
    public <T2> Filter none(Query<T2> subQuery) {
        if (this.conditionAppend(null, null, subQuery)) {
            this.subQueryNone(subQuery);
        }
        return this;
    }

    @Override
    public Filter range(TableAvailable table, String property, boolean conditionLeft, Object valLeft, boolean conditionRight, Object valRight, SQLRangeEnum sqlRange) {
        if (conditionLeft && this.conditionAppend(table, property, valLeft)) {
            boolean openFirst = SQLRangeEnum.openFirst(sqlRange);
            this.appendThisPredicate(table, property, valLeft, this.getReallyPredicateCompare(openFirst ? SQLPredicateCompareEnum.GT : SQLPredicateCompareEnum.GE));
            this.next();
        }
        if (conditionRight && this.conditionAppend(table, property, valRight)) {
            boolean openEnd = SQLRangeEnum.openEnd(sqlRange);
            this.appendThisPredicate(table, property, valRight, this.getReallyPredicateCompare(openEnd ? SQLPredicateCompareEnum.LT : SQLPredicateCompareEnum.LE));
            this.next();
        }
        return this;
    }

    @Override
    public Filter columnFunc(TableAvailable table, ColumnPropertyFunction columnPropertyFunction, SQLPredicateCompare sqlPredicateCompare, Object val) {
        if (this.conditionAppend(table, columnPropertyFunction.getPropertyName(), val)) {
            this.appendThisFuncPredicate(table, columnPropertyFunction.getPropertyName(), columnPropertyFunction.getColumnFunction(), this.getReallyPredicateCompare(sqlPredicateCompare), val);
            this.next();
        }
        return this;
    }

    @Override
    public Filter compareSelf(TableAvailable leftTable, String property1, TableAvailable rightTable, String property2, SQLPredicateCompare sqlPredicateCompare) {
        this.nextPredicateSegment.setPredicate(new ColumnWithColumnPredicate(leftTable, property1, rightTable, property2, this.getReallyPredicateCompare(sqlPredicateCompare), this.expressionContext));
        this.next();
        return this;
    }

    @Override
    public Filter like(TableAvailable leftTable, String property1, TableAvailable rightTable, String property2, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.column(leftTable, property1).column(rightTable, property2), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public Filter like(TableAvailable leftTable, String property1, TableAvailable rightTable, SQLFunction sqlFunction, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.column(leftTable, property1).sqlFunc(rightTable, sqlFunction), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public Filter like(TableAvailable leftTable, SQLFunction sqlFunction, TableAvailable rightTable, String property2, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.sqlFunc(leftTable, sqlFunction).column(rightTable, property2), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public Filter like(TableAvailable leftTable, SQLFunction sqlFunction1, TableAvailable rightTable, SQLFunction sqlFunction2, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.sqlFunc(leftTable, sqlFunction1).sqlFunc(rightTable, sqlFunction2), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    private Filter getLikePredicateFilter(TableAvailable leftTable, SQLNativeExpressionContextImpl sqlNativeExpressionContext, SQLFunction likeSQLFunction) {
        String sqlSegment = likeSQLFunction.sqlSegment(leftTable);
        likeSQLFunction.consume(new SQLNativeChainExpressionContextImpl(leftTable, sqlNativeExpressionContext));
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment, sqlNativeExpressionContext));
        this.next();
        return this;
    }

    @Override
    public <TProperty> Filter subQueryFilter(TableAvailable table, String property, Query<TProperty> subQuery, SQLPredicateCompare sqlPredicateCompare) {
        if (this.conditionAppend(table, property, subQuery)) {
            this.subQueryFilter0(table, property, subQuery, sqlPredicateCompare);
        }
        return this;
    }

    @Override
    public Filter funcValueFilter(TableAvailable table, SQLFunction sqlFunction, Object val, SQLPredicateCompare sqlPredicateCompare) {
        if (this.conditionAppend(table, null, val)) {
            this.funcValueFilter0(table, sqlFunction, val, sqlPredicateCompare);
        }
        return this;
    }

    @Override
    public Filter funcColumnFilter(TableAvailable table1, SQLFunction sqlFunction, TableAvailable table2, String property, SQLPredicateCompare sqlPredicateCompare) {
        this.funcColumnFilter0(table1, sqlFunction, table2, property, sqlPredicateCompare);
        return this;
    }

    @Override
    public <TProperty> Filter funcSubQueryFilter(TableAvailable table, SQLFunction sqlFunction, Query<TProperty> subQuery, SQLPredicateCompare sqlPredicateCompare) {
        if (this.conditionAppend(table, null, subQuery)) {
            this.funcSubQueryFilter0(table, sqlFunction, subQuery, sqlPredicateCompare);
        }
        return this;
    }

    @Override
    public <TProperty> Filter funcInFilter(TableAvailable table, SQLFunction sqlFunction, Collection<TProperty> collections, SQLPredicateCompare sqlPredicateCompare) {
        if (this.conditionAppend(table, null, collections)) {
            this.funcInFilter0(table, sqlFunction, collections, sqlPredicateCompare);
        }
        return this;
    }

    @Override
    public Filter valueFuncFilter(TableAvailable table, String property, TableAvailable tableRight, SQLFunction sqlFunction, SQLPredicateCompare sqlPredicateCompare) {
        if (this.conditionAppend(table, property, sqlFunction)) {
            this.valueFuncFilter0(table, property, tableRight, sqlFunction, sqlPredicateCompare);
        }
        return this;
    }

    @Override
    public Filter funcColumnFuncFilter(TableAvailable tableLeft, SQLFunction sqlFunctionLeft, TableAvailable tableRight, SQLFunction sqlFunctionRight, SQLPredicateCompare sqlPredicateCompare) {
        if (this.conditionAppend(tableLeft, null, sqlFunctionRight)) {
            this.funcColumnFuncFilter0(tableLeft, sqlFunctionLeft, tableRight, sqlFunctionRight, sqlPredicateCompare);
        }
        return this;
    }

    @Override
    public Filter sqlNativeSegment(String sqlSegment, SQLExpression1<SQLNativeExpressionContext> contextConsume) {
        Objects.requireNonNull(contextConsume, "sql native context consume cannot be null");
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        contextConsume.apply(sqlNativeExpressionContext);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment, sqlNativeExpressionContext));
        this.next();
        return this;
    }

    protected void and0() {
        this.nextPredicateSegment = this.reverse ? new OrPredicateSegment() : new AndPredicateSegment();
    }

    @Override
    public Filter and() {
        this.and0();
        return this;
    }

    @Override
    public Filter and(SQLExpression1<Filter> sqlWherePredicateSQLExpression) {
        this.and0();
        Filter filter = this.create();
        sqlWherePredicateSQLExpression.apply(filter);
        this.next();
        return this;
    }

    protected void or0() {
        this.nextPredicateSegment = this.reverse ? new AndPredicateSegment() : new OrPredicateSegment();
    }

    @Override
    public Filter or() {
        this.or0();
        return this;
    }

    @Override
    public Filter or(SQLExpression1<Filter> sqlWherePredicateSQLExpression) {
        this.or0();
        Filter filter = this.create();
        sqlWherePredicateSQLExpression.apply(filter);
        this.next();
        return this;
    }

    @Override
    public Filter create() {
        return new FilterImpl(this.runtimeContext, this.expressionContext, this.nextPredicateSegment, this.reverse, this.conditionAcceptAssert);
    }
}

