/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.executor.parser;

import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.expression.executor.parser.QueryPrepareParseResult;
import com.easy.query.core.expression.executor.parser.SequenceParseResult;
import com.easy.query.core.expression.executor.parser.context.QueryPredicateParseContext;
import com.easy.query.core.expression.executor.parser.descriptor.TableParseDescriptor;
import com.easy.query.core.expression.executor.parser.descriptor.TablePredicateParseDescriptor;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.FuncColumnSegment;
import com.easy.query.core.expression.segment.OrderBySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityQuerySQLExpression;
import com.easy.query.core.metadata.ShardingInitConfig;
import com.easy.query.core.metadata.ShardingSequenceConfig;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import com.easy.query.core.util.EasyShardingUtil;
import java.util.Objects;

public class EasyQueryPrepareParseResult
implements QueryPrepareParseResult {
    private final ExecutorContext executorContext;
    private final TablePredicateParseDescriptor tablePredicateParseDescriptor;
    private final EntityQueryExpressionBuilder entityQueryExpressionBuilder;
    private final EntityQuerySQLExpression easyQuerySQLExpression;
    private final boolean sharding;
    private boolean startsWithGroupByInOrderBy;
    private final int maxShardingQueryLimit;
    private final ConnectionModeEnum connectionMode;
    private final long originalOffset;
    private final long originalRows;
    private final SequenceParseResult sequenceParseResult;

    public EasyQueryPrepareParseResult(QueryPredicateParseContext queryPredicatePrepareParseContext, TablePredicateParseDescriptor tablePredicateParseDescriptor) {
        this.executorContext = queryPredicatePrepareParseContext.getExecutorContext();
        this.tablePredicateParseDescriptor = tablePredicateParseDescriptor;
        this.entityQueryExpressionBuilder = queryPredicatePrepareParseContext.getEntityExpressionBuilder();
        this.easyQuerySQLExpression = queryPredicatePrepareParseContext.getEntityPredicateSQLExpression();
        this.sharding = EasyCollectionUtil.isNotEmpty(tablePredicateParseDescriptor.getTables());
        this.originalOffset = this.easyQuerySQLExpression.getOffset();
        this.originalRows = this.easyQuerySQLExpression.getRows();
        this.sequenceParseResult = this.initSequenceOrderPrepareParseResult(this.executorContext);
        this.maxShardingQueryLimit = EasyShardingUtil.getMaxShardingQueryLimit(this.entityQueryExpressionBuilder, this.sequenceParseResult);
        this.connectionMode = EasyShardingUtil.getConnectionMode(this.entityQueryExpressionBuilder, this.sequenceParseResult);
    }

    private SequenceParseResult initSequenceOrderPrepareParseResult(ExecutorContext executorContext) {
        if (this.sharding) {
            EasyQueryOption easyQueryOption = executorContext.getRuntimeContext().getQueryConfiguration().getEasyQueryOption();
            SQLBuilderSegment order = this.easyQuerySQLExpression.getOrder();
            if (EasySQLSegmentUtil.isNotEmpty(order)) {
                Boolean asc;
                SQLSegment firstOrder = EasyCollectionUtil.first(order.getSQLSegments());
                OrderBySegment firstOrderColumn = (OrderBySegment)firstOrder;
                TableAvailable table = firstOrderColumn.getTable();
                ShardingInitConfig shardingInitConfig = table.getEntityMetadata().getShardingInitConfig();
                ShardingSequenceConfig shardingSequenceConfig = shardingInitConfig.getShardingSequenceConfig();
                if (shardingSequenceConfig != null && (asc = shardingSequenceConfig.getSequenceProperty(firstOrderColumn.getPropertyName())) != null) {
                    boolean reverse = !firstOrderColumn.isAsc();
                    return new SequenceParseResult(table, shardingSequenceConfig.getTableComparator(), reverse, shardingSequenceConfig.getConnectionModeOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getConnectionMode()), shardingSequenceConfig.getMaxShardingQueryLimitOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getMaxShardingQueryLimit()));
                }
            } else if (Objects.equals((Object)ExecuteMethodEnum.MAX, (Object)executorContext.getExecuteMethod())) {
                Boolean asc;
                FuncColumnSegment firstMaxColumn;
                TableAvailable table;
                ShardingInitConfig shardingInitConfig;
                ShardingSequenceConfig shardingSequenceConfig;
                SQLSegment firstMax = EasyCollectionUtil.first(this.easyQuerySQLExpression.getProjects().getSQLSegments());
                if (firstMax instanceof FuncColumnSegment && (shardingSequenceConfig = (shardingInitConfig = (table = (firstMaxColumn = (FuncColumnSegment)firstMax).getTable()).getEntityMetadata().getShardingInitConfig()).getShardingSequenceConfig()) != null && (asc = shardingSequenceConfig.getSequenceProperty(firstMaxColumn.getPropertyName())) != null) {
                    return new SequenceParseResult(table, shardingSequenceConfig.getTableComparator(), true, shardingSequenceConfig.getConnectionModeOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getConnectionMode()), shardingSequenceConfig.getMaxShardingQueryLimitOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getMaxShardingQueryLimit()));
                }
            } else if (Objects.equals((Object)ExecuteMethodEnum.MIN, (Object)executorContext.getExecuteMethod())) {
                Boolean asc;
                FuncColumnSegment firstMinColumn;
                TableAvailable table;
                ShardingInitConfig shardingInitConfig;
                ShardingSequenceConfig shardingSequenceConfig;
                SQLSegment firstMin = EasyCollectionUtil.first(this.easyQuerySQLExpression.getProjects().getSQLSegments());
                if (firstMin instanceof FuncColumnSegment && (shardingSequenceConfig = (shardingInitConfig = (table = (firstMinColumn = (FuncColumnSegment)firstMin).getTable()).getEntityMetadata().getShardingInitConfig()).getShardingSequenceConfig()) != null && (asc = shardingSequenceConfig.getSequenceProperty(firstMinColumn.getPropertyName())) != null) {
                    return new SequenceParseResult(table, shardingSequenceConfig.getTableComparator(), false, shardingSequenceConfig.getConnectionModeOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getConnectionMode()), shardingSequenceConfig.getMaxShardingQueryLimitOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getMaxShardingQueryLimit()));
                }
            } else {
                TableAvailable table = EasyCollectionUtil.first(this.tablePredicateParseDescriptor.getTables());
                ShardingInitConfig shardingInitConfig = table.getEntityMetadata().getShardingInitConfig();
                ShardingSequenceConfig shardingSequenceConfig = shardingInitConfig.getShardingSequenceConfig();
                if (shardingSequenceConfig != null && shardingSequenceConfig.hasCompareMethods(executorContext.getExecuteMethod())) {
                    boolean asc = shardingSequenceConfig.hasCompareAscMethods(executorContext.getExecuteMethod());
                    boolean reverse = !asc;
                    return new SequenceParseResult(table, shardingSequenceConfig.getTableComparator(), reverse, shardingSequenceConfig.getConnectionModeOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getConnectionMode()), shardingSequenceConfig.getMaxShardingQueryLimitOrDefault(executorContext.getExecuteMethod(), easyQueryOption.getMaxShardingQueryLimit()));
                }
            }
        }
        return null;
    }

    @Override
    public ExecutorContext getExecutorContext() {
        return this.executorContext;
    }

    @Override
    public TableParseDescriptor getTableParseDescriptor() {
        return this.tablePredicateParseDescriptor;
    }

    @Override
    public EntityQueryExpressionBuilder getEntityExpressionBuilder() {
        return this.entityQueryExpressionBuilder;
    }

    @Override
    public long getOriginalOffset() {
        return this.originalOffset;
    }

    @Override
    public long getOriginalRows() {
        return this.originalRows;
    }

    @Override
    public boolean isSharding() {
        return this.sharding;
    }

    @Override
    public boolean isStartsWithGroupByInOrderBy() {
        return this.startsWithGroupByInOrderBy;
    }

    @Override
    public void setStartsWithGroupByInOrderBy(boolean startsWithGroupByInOrderBy) {
        this.startsWithGroupByInOrderBy = startsWithGroupByInOrderBy;
    }

    @Override
    public TablePredicateParseDescriptor getTablePredicateParseDescriptor() {
        return this.tablePredicateParseDescriptor;
    }

    @Override
    public EntityQuerySQLExpression getEntityPredicateSQLExpression() {
        return this.easyQuerySQLExpression;
    }

    @Override
    public SequenceParseResult getSequenceParseResult() {
        return this.sequenceParseResult;
    }

    @Override
    public int getMaxShardingQueryLimit() {
        return this.maxShardingQueryLimit;
    }

    @Override
    public ConnectionModeEnum getConnectionMode() {
        return this.connectionMode;
    }
}

