/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.executor.parser.descriptor.impl;

import com.easy.query.core.expression.executor.parser.descriptor.TablePredicateParseDescriptor;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.util.EasyMapUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TablePredicateParseDescriptorImpl
implements TablePredicateParseDescriptor {
    private final Map<TableAvailable, List<PredicateSegment>> tablePredicates;

    public TablePredicateParseDescriptorImpl() {
        this(Collections.emptyMap());
    }

    public TablePredicateParseDescriptorImpl(Map<TableAvailable, List<PredicateSegment>> tablePredicates) {
        this.tablePredicates = tablePredicates;
    }

    @Override
    public void addTable(TableAvailable table) {
        if (!this.tablePredicates.containsKey(table)) {
            this.tablePredicates.put(table, new ArrayList());
        }
    }

    @Override
    public void addTablePredicate(TableAvailable table, PredicateSegment predicateSegment) {
        List predicateSegments = EasyMapUtil.computeIfAbsent(this.tablePredicates, table, o -> new ArrayList());
        predicateSegments.add(predicateSegment);
    }

    @Override
    public List<PredicateSegment> getPredicatesOrNull(TableAvailable table) {
        return this.tablePredicates.get(table);
    }

    @Override
    public boolean isShardingTable(TableAvailable table) {
        return this.tablePredicates.containsKey(table);
    }

    @Override
    public Set<TableAvailable> getTables() {
        return this.tablePredicates.keySet();
    }
}

