/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.executor.query.base;

import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.internal.common.ExecutionUnit;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.expression.executor.query.base.BaseExecutionCreator;
import com.easy.query.core.expression.sql.builder.EntityExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntitySQLExpression;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class BaseEntityExecutionCreator
extends BaseExecutionCreator {
    protected final String dataSource;
    protected final EntityExpressionBuilder entityExpressionBuilder;
    protected final List<Object> entities;
    private final ExecutorContext executorContext;

    public BaseEntityExecutionCreator(String dataSource, EntityExpressionBuilder entityExpressionBuilder, List<Object> entities, ExecutorContext executorContext) {
        this.dataSource = dataSource;
        this.entityExpressionBuilder = entityExpressionBuilder;
        this.entities = entities;
        this.executorContext = executorContext;
    }

    @Override
    protected List<ExecutionUnit> createExecutionUnits() {
        if (!Objects.equals((Object)ExecuteMethodEnum.DELETE, (Object)this.executorContext.getExecuteMethod())) {
            return this.createSingleExecutionUnits();
        }
        return this.createMultiExecutionUnits();
    }

    protected List<ExecutionUnit> createSingleExecutionUnits() {
        ArrayList<ExecutionUnit> routeExecutionUnits = new ArrayList<ExecutionUnit>(this.entities.size());
        for (Object entity : this.entities) {
            EntitySQLExpression expression = this.createEasySQLExpression(entity);
            ExecutionUnit executionUnit = this.createExecutionUnit(this.dataSource, expression, Collections.singletonList(entity), this.getFillAutoIncrement(), null);
            if (!EasyStringUtil.isNotBlank(executionUnit.getSQLRouteUnit().getSQL())) continue;
            routeExecutionUnits.add(executionUnit);
        }
        return this.createBatchExecutionUnits(routeExecutionUnits);
    }

    @Override
    protected boolean useEntityBatch() {
        if (this.entityExpressionBuilder.getExpressionContext().getBehavior().hasBehavior(EasyBehaviorEnum.EXECUTE_NO_BATCH)) {
            return false;
        }
        int entitySize = this.entities.size();
        return this.entityExpressionBuilder.getExpressionContext().getBehavior().hasBehavior(EasyBehaviorEnum.EXECUTE_BATCH) || EasySQLExpressionUtil.entityExecuteBatch(entitySize, this.executorContext);
    }

    private List<ExecutionUnit> createMultiExecutionUnits() {
        EntitySQLExpression expression = this.entityExpressionBuilder.toExpression();
        ExecutionUnit executionUnit = this.createExecutionUnit(this.dataSource, expression, this.entities, this.getFillAutoIncrement(), null);
        return Collections.singletonList(executionUnit);
    }

    protected abstract EntitySQLExpression createEasySQLExpression(Object var1);

    protected abstract boolean getFillAutoIncrement();
}

