/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.executor.query.base;

import com.easy.query.core.basic.jdbc.executor.internal.common.ExecutionUnit;
import com.easy.query.core.basic.jdbc.executor.internal.common.SQLRewriteUnit;
import com.easy.query.core.basic.jdbc.executor.internal.common.SQLRouteUnit;
import com.easy.query.core.enums.MergeBehaviorEnum;
import com.easy.query.core.expression.executor.parser.ExecutionContext;
import com.easy.query.core.expression.executor.query.base.ExecutionCreator;
import com.easy.query.core.expression.sql.expression.EntitySQLExpression;
import com.easy.query.core.util.EasyMapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseExecutionCreator
implements ExecutionCreator {
    protected ExecutionUnit createExecutionUnit(String dataSource, EntitySQLExpression expression, List<Object> entities, boolean fillAutoIncrement, SQLRewriteUnit sqlRewriteUnit) {
        SQLRouteUnit sqlUnit = this.createSQLUnit(expression, entities, fillAutoIncrement, sqlRewriteUnit);
        return this.createExecutionUnit(dataSource, sqlUnit);
    }

    protected SQLRouteUnit createSQLUnit(EntitySQLExpression expression, List<Object> entities, boolean fillAutoIncrement, SQLRewriteUnit sqlRewriteUnit) {
        return new SQLRouteUnit(expression, entities, fillAutoIncrement, sqlRewriteUnit);
    }

    protected ExecutionUnit createExecutionUnit(String dataSource, SQLRouteUnit sqlUnit) {
        return new ExecutionUnit(dataSource, sqlUnit);
    }

    protected ExecutionContext createExecutionContext(List<ExecutionUnit> executionUnits) {
        return new ExecutionContext(executionUnits, this.sequenceQuery(), this.isCrossTable(), this.isCrossDataSource(), this.isReverseMerge(), this.mergeBehavior());
    }

    protected int mergeBehavior() {
        return MergeBehaviorEnum.DEFAULT.getCode();
    }

    protected boolean sequenceQuery() {
        return false;
    }

    protected boolean isCrossTable() {
        return false;
    }

    protected boolean isCrossDataSource() {
        return false;
    }

    protected boolean isReverseMerge() {
        return false;
    }

    @Override
    public ExecutionContext create() {
        List<ExecutionUnit> executionUnits = this.createExecutionUnits();
        return this.createExecutionContext(executionUnits);
    }

    protected abstract List<ExecutionUnit> createExecutionUnits();

    protected boolean useEntityBatch() {
        return false;
    }

    protected List<ExecutionUnit> createBatchExecutionUnits(List<ExecutionUnit> executionUnits) {
        boolean useBatch = this.useEntityBatch();
        if (useBatch) {
            ArrayList<ExecutionUnit> batchExecutionUnits = new ArrayList<ExecutionUnit>(executionUnits.size());
            HashMap lastUnitMap = new HashMap();
            for (ExecutionUnit executionUnit : executionUnits) {
                ArrayList<Object> entities;
                String dataSourceName = executionUnit.getDataSourceName();
                SQLRouteUnit sqlRouteUnit = executionUnit.getSQLRouteUnit();
                String sql = sqlRouteUnit.getSQL();
                Map sqlExecutionUnitMap = EasyMapUtil.computeIfAbsent(lastUnitMap, dataSourceName, o -> new HashMap());
                ExecutionUnit lastUnit = (ExecutionUnit)sqlExecutionUnitMap.get(sql);
                if (lastUnit == null || !lastUnit.isSame(executionUnit)) {
                    entities = new ArrayList<Object>();
                    entities.addAll(sqlRouteUnit.getEntities());
                    lastUnit = new ExecutionUnit(dataSourceName, new SQLRouteUnit(sql, sqlRouteUnit.getParameters(), entities, sqlRouteUnit.isFillAutoIncrement()));
                    batchExecutionUnits.add(lastUnit);
                    sqlExecutionUnitMap.put(sql, lastUnit);
                    continue;
                }
                entities = executionUnit.getSQLRouteUnit().getEntities();
                lastUnit.getSQLRouteUnit().getEntities().addAll(entities);
            }
            lastUnitMap.clear();
            return batchExecutionUnits;
        }
        return executionUnits;
    }
}

