/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.executor.query.base;

import com.easy.query.core.basic.jdbc.executor.internal.common.ExecutionUnit;
import com.easy.query.core.basic.jdbc.executor.internal.common.SQLRewriteUnitImpl;
import com.easy.query.core.basic.jdbc.executor.internal.common.SQLRouteUnit;
import com.easy.query.core.expression.executor.query.base.BaseExecutionCreator;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.expression.EntitySQLExpression;
import com.easy.query.core.sharding.rewrite.RewriteContext;
import com.easy.query.core.sharding.rewrite.RewriteRouteUnit;
import com.easy.query.core.sharding.router.RouteUnit;
import com.easy.query.core.sharding.router.table.EntityTableRouteUnit;
import com.easy.query.core.sharding.router.table.TableRouteUnit;
import com.easy.query.core.sharding.router.table.TableUnit;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class ShardingBaseExecutionCreator
extends BaseExecutionCreator {
    private final RewriteContext rewriteContext;

    public ShardingBaseExecutionCreator(RewriteContext rewriteContext) {
        this.rewriteContext = rewriteContext;
    }

    @Override
    protected int mergeBehavior() {
        return this.rewriteContext.getMergeBehavior();
    }

    @Override
    protected boolean sequenceQuery() {
        return this.rewriteContext.isSequenceQuery();
    }

    @Override
    protected boolean isCrossTable() {
        return this.rewriteContext.isCrossTable();
    }

    @Override
    protected boolean isCrossDataSource() {
        return this.rewriteContext.isCrossDataSource();
    }

    @Override
    protected boolean isReverseMerge() {
        return this.rewriteContext.isReverseMerge();
    }

    @Override
    protected List<ExecutionUnit> createExecutionUnits() {
        List<RewriteRouteUnit> rewriteRouteUnits = this.getRewriteRouteUnits();
        ArrayList<ExecutionUnit> executionUnits = new ArrayList<ExecutionUnit>(rewriteRouteUnits.size());
        for (RewriteRouteUnit rewriteRouteUnit : rewriteRouteUnits) {
            RouteUnit routeUnit = rewriteRouteUnit.getRouteUnit();
            String dataSource = routeUnit.getDataSource();
            List<TableRouteUnit> tableRouteUnits = routeUnit.getTableRouteUnits();
            Map<TableAvailable, String> tableNameRewriteMap = EasyCollectionUtil.collectionToMap(tableRouteUnits, TableRouteUnit::getTable, TableUnit::getActualTableName);
            SQLRewriteUnitImpl sqlRewriteUnit = new SQLRewriteUnitImpl(tableNameRewriteMap);
            EntitySQLExpression entitySQLExpression = this.createEntitySQLExpression(rewriteRouteUnit);
            List<Object> entities = this.getEntitiesByTableRouteUnits(tableRouteUnits);
            boolean fillAutoIncrement = this.getFillAutoIncrement(routeUnit);
            SQLRouteUnit sqlUnit = this.createSQLUnit(entitySQLExpression, entities, fillAutoIncrement, sqlRewriteUnit);
            ExecutionUnit executionUnit = this.createExecutionUnit(dataSource, sqlUnit);
            executionUnits.add(executionUnit);
        }
        return executionUnits;
    }

    private List<Object> getEntitiesByTableRouteUnits(List<TableRouteUnit> tableRouteUnits) {
        TableRouteUnit tableRouteUnit;
        if (EasyCollectionUtil.isSingle(tableRouteUnits) && (tableRouteUnit = EasyCollectionUtil.first(tableRouteUnits)) instanceof EntityTableRouteUnit) {
            return Collections.singletonList(((EntityTableRouteUnit)tableRouteUnit).getEntity());
        }
        return null;
    }

    protected List<RewriteRouteUnit> getRewriteRouteUnits() {
        return this.rewriteContext.getRewriteRouteUnits();
    }

    protected abstract List<Object> getEntities(RouteUnit var1);

    protected abstract boolean getFillAutoIncrement(RouteUnit var1);

    protected abstract EntitySQLExpression createEntitySQLExpression(RewriteRouteUnit var1);
}

