/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.include;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.include.IncludeProcessor;
import com.easy.query.core.expression.sql.include.IncludeParserResult;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractIncludeProcessor
implements IncludeProcessor {
    protected final Collection<RelationExtraEntity> entities;
    protected final EntityMetadata selfEntityMetadata;
    protected final IncludeParserResult includeParserResult;
    protected final QueryRuntimeContext runtimeContext;
    protected final EntityMetadata targetEntityMetadata;
    protected final String targetColumnMetadataPropertyName;
    protected Class<?> collectionType;

    public AbstractIncludeProcessor(IncludeParserResult includeParserResult, QueryRuntimeContext runtimeContext) {
        this.entities = includeParserResult.getRelationExtraEntities();
        this.includeParserResult = includeParserResult;
        this.selfEntityMetadata = includeParserResult.getEntityMetadata();
        this.runtimeContext = runtimeContext;
        this.targetEntityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(includeParserResult.getNavigatePropertyType());
        this.targetColumnMetadataPropertyName = this.getTargetRelationColumn();
    }

    private String getTargetRelationColumn() {
        return EasyStringUtil.isBlank(this.includeParserResult.getTargetProperty()) ? this.getTargetSingleKeyProperty() : this.includeParserResult.getTargetProperty();
    }

    private String getTargetSingleKeyProperty() {
        Collection<String> keyProperties = this.targetEntityMetadata.getKeyProperties();
        if (EasyCollectionUtil.isNotSingle(keyProperties)) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName(this.targetEntityMetadata.getEntityClass()) + "multi key not support include");
        }
        return EasyCollectionUtil.first(keyProperties);
    }

    protected <TNavigateEntity> Map<Object, Collection<TNavigateEntity>> getTargetToManyMap(List<RelationExtraEntity> includes) {
        Class<? extends Collection> collectionType = EasyClassUtil.getCollectionImplType(this.includeParserResult.getNavigateOriginalPropertyType());
        HashMap<Object, Collection<TNavigateEntity>> resultMap = new HashMap<Object, Collection<TNavigateEntity>>();
        for (RelationExtraEntity target : includes) {
            Object targetRelationId = target.getRelationExtraColumn(this.targetColumnMetadataPropertyName);
            Collection objects = resultMap.computeIfAbsent(targetRelationId, k -> (Collection)EasyClassUtil.newInstance(collectionType));
            objects.add(target.getEntity());
        }
        return resultMap;
    }

    protected Class<?> getCollectionType() {
        if (this.collectionType == null) {
            this.collectionType = EasyClassUtil.getCollectionImplType(this.includeParserResult.getNavigateOriginalPropertyType());
        }
        return this.collectionType;
    }

    protected <TNavigateEntity> Collection<TNavigateEntity> createManyCollection() {
        Class<?> collectionType = this.getCollectionType();
        return (Collection)EasyObjectUtil.typeCastNullable(EasyClassUtil.newInstance(collectionType));
    }

    protected <TNavigateEntity> Map<Object, Collection<TNavigateEntity>> getTargetToManyMap(List<RelationExtraEntity> includes, List<Map<String, Object>> mappingRows) {
        HashMap<Object, Collection<TNavigateEntity>> resultMap = new HashMap<Object, Collection<TNavigateEntity>>();
        EntityMetadata entityMetadata = this.runtimeContext.getEntityMetadataManager().getEntityMetadata(this.includeParserResult.getMappingClass());
        ColumnMetadata selfRelationColumn = entityMetadata.getColumnNotNull(this.includeParserResult.getSelfMappingProperty());
        String selfColumnName = selfRelationColumn.getName();
        ColumnMetadata targetRelationColumn = entityMetadata.getColumnNotNull(this.includeParserResult.getTargetMappingProperty());
        String targetColumnName = targetRelationColumn.getName();
        Map<Object, Collection<TNavigateEntity>> targetToManyMap = this.getTargetToManyMap(includes);
        for (Map<String, Object> mappingRow : mappingRows) {
            Object selfRelationId = mappingRow.get(selfColumnName);
            Object targetRelationId = mappingRow.get(targetColumnName);
            Collection targetEntities = resultMap.computeIfAbsent(selfRelationId, k -> this.createManyCollection());
            Collection<TNavigateEntity> targets = targetToManyMap.get(targetRelationId);
            if (!EasyCollectionUtil.isNotEmpty(targets)) continue;
            targetEntities.addAll(targets);
        }
        return resultMap;
    }

    @Override
    public void process() {
        switch (this.includeParserResult.getRelationType()) {
            case OneToOne: {
                this.OneToOneProcess(this.includeParserResult.getIncludeResult());
                return;
            }
            case OneToMany: {
                this.OneToManyProcess(this.includeParserResult.getIncludeResult());
                return;
            }
            case ManyToOne: {
                this.ManyToOneProcess(this.includeParserResult.getIncludeResult());
                return;
            }
            case ManyToMany: {
                this.ManyToManyProcess(this.includeParserResult.getIncludeResult(), this.includeParserResult.getMappingRows());
                return;
            }
        }
        throw new UnsupportedOperationException("not support include relation type:" + (Object)((Object)this.includeParserResult.getRelationType()));
    }

    protected abstract void OneToOneProcess(List<RelationExtraEntity> var1);

    protected abstract void ManyToOneProcess(List<RelationExtraEntity> var1);

    protected abstract void OneToManyProcess(List<RelationExtraEntity> var1);

    protected abstract void ManyToManyProcess(List<RelationExtraEntity> var1, List<Map<String, Object>> var2);

    protected <T> void setEntityValue(T entity, Object value) {
        this.includeParserResult.getSetter().call(entity, value);
    }

    public String getSelfRelationColumn() {
        return this.includeParserResult.getSelfProperty();
    }
}

