/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.include;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.RelationMappingTypeEnum;
import com.easy.query.core.expression.include.EasyIncludeProcess;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.sql.include.IncludeParserResult;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.metadata.NavigateFlatMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;

public class EasyFlatIncludeProcessor
extends EasyIncludeProcess {
    private final NavigateFlatMetadata navigateFlatMetadata;
    private Property<Object, Collection<?>> navigateFlatGetter;

    public EasyFlatIncludeProcessor(NavigateFlatMetadata navigateFlatMetadata, IncludeParserResult includeParserResult, QueryRuntimeContext runtimeContext) {
        super(includeParserResult, runtimeContext);
        this.navigateFlatMetadata = navigateFlatMetadata;
        this.initNavigateFlatGetter(includeParserResult, includeParserResult.getFlatQueryEntityMetadata(), navigateFlatMetadata, runtimeContext);
    }

    public void initNavigateFlatGetter(IncludeParserResult includeParserResult, EntityMetadata flatQueryEntityMetadata, NavigateFlatMetadata navigateFlatMetadata, QueryRuntimeContext runtimeContext) {
        if (navigateFlatMetadata == null) {
            return;
        }
        boolean basicType = navigateFlatMetadata.isBasicType();
        EntityMetadataManager entityMetadataManager = runtimeContext.getEntityMetadataManager();
        Iterator mappingPathIterator = Arrays.stream(navigateFlatMetadata.getMappingPath()).iterator();
        String firstNavValue = (String)mappingPathIterator.next();
        ArrayList replyExpressions = new ArrayList();
        NavigateMetadata currentNavigateMetadata = flatQueryEntityMetadata.getNavigateNotNull(firstNavValue);
        EntityMetadata currentEntityMetadata = entityMetadataManager.getEntityMetadata(currentNavigateMetadata.getNavigatePropertyType());
        while (mappingPathIterator.hasNext()) {
            String currentNavValue = (String)mappingPathIterator.next();
            if (!mappingPathIterator.hasNext() && basicType) {
                ColumnMetadata columnMetadata = currentEntityMetadata.getColumnNotNull(currentNavValue);
                replyExpressions.add(columnMetadata.getGetterCaller());
                break;
            }
            currentNavigateMetadata = currentEntityMetadata.getNavigateNotNull(currentNavValue);
            currentEntityMetadata = entityMetadataManager.getEntityMetadata(currentNavigateMetadata.getNavigatePropertyType());
            replyExpressions.add(currentNavigateMetadata.getGetter());
        }
        this.navigateFlatGetter = obj -> {
            if (obj == null) {
                return null;
            }
            Iterator iterator = replyExpressions.iterator();
            Property first = (Property)iterator.next();
            Collection collectionValues = this.getCollectionValue(obj, first);
            while (iterator.hasNext()) {
                Property getter = (Property)iterator.next();
                collectionValues = collectionValues.stream().map(o -> this.getCollectionValue(o, getter)).flatMap(o -> o.stream()).filter(o -> o != null).distinct().collect(Collectors.toList());
            }
            return collectionValues;
        };
    }

    private Collection<Object> getCollectionValue(Object obj, Property<Object, ?> getter) {
        Object value = getter.apply(obj);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    @Override
    protected <T> void setEntityValue(T entity, Object value) {
        if (this.navigateFlatMetadata != null) {
            Collection values = null;
            values = value instanceof Collection ? (Collection)((Collection)value).stream().map(o -> this.navigateFlatGetter.apply(o)).flatMap(o -> o.stream()).distinct().collect(Collectors.toList()) : this.navigateFlatGetter.apply(value);
            if (this.navigateFlatMetadata.getRelationMappingType() == RelationMappingTypeEnum.ToOne) {
                this.navigateFlatMetadata.getBeanSetter().call(entity, EasyCollectionUtil.firstOrNull(values));
            } else {
                this.navigateFlatMetadata.getBeanSetter().call(entity, values);
            }
        } else {
            super.setEntityValue(entity, value);
        }
    }
}

