/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.include;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.include.AbstractIncludeProcessor;
import com.easy.query.core.expression.sql.include.IncludeParserResult;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EasyIncludeProcess
extends AbstractIncludeProcessor {
    public EasyIncludeProcess(IncludeParserResult includeParserResult, QueryRuntimeContext runtimeContext) {
        super(includeParserResult, runtimeContext);
    }

    @Override
    protected void OneToOneProcess(List<RelationExtraEntity> includes) {
        String selfRelationColumn = this.getSelfRelationColumn();
        Map<Object, Object> entityMap = EasyCollectionUtil.collectionToMap(this.entities, x -> x.getRelationExtraColumn(selfRelationColumn), o -> o.getEntity());
        for (RelationExtraEntity includeEntity : includes) {
            Object subRelationKey = includeEntity.getRelationExtraColumn(this.targetColumnMetadataPropertyName);
            Object entity = entityMap.get(subRelationKey);
            if (entity == null) continue;
            this.setEntityValue(entity, includeEntity.getEntity());
        }
    }

    @Override
    protected void ManyToOneProcess(List<RelationExtraEntity> includes) {
        Map<Object, Object> includeMap = EasyCollectionUtil.collectionToMap(includes, x -> x.getRelationExtraColumn(this.targetColumnMetadataPropertyName), o -> o.getEntity());
        String selfRelationColumn = this.getSelfRelationColumn();
        for (RelationExtraEntity entity : this.entities) {
            Object relationId = entity.getRelationExtraColumn(selfRelationColumn);
            Object entityInclude = includeMap.get(relationId);
            if (entityInclude == null) continue;
            this.setEntityValue(entity.getEntity(), entityInclude);
        }
    }

    @Override
    protected void OneToManyProcess(List<RelationExtraEntity> includes) {
        String selfRelationColumn = this.getSelfRelationColumn();
        Map targetToManyMap = this.getTargetToManyMap(includes);
        for (RelationExtraEntity entity : this.entities) {
            Object selfRelationId = entity.getRelationExtraColumn(selfRelationColumn);
            Collection targetEntities = targetToManyMap.computeIfAbsent(selfRelationId, k -> this.createManyCollection());
            this.setEntityValue(entity.getEntity(), targetEntities);
        }
    }

    @Override
    protected void ManyToManyProcess(List<RelationExtraEntity> includes, List<Map<String, Object>> mappingRows) {
        Map targetToManyMap = this.getTargetToManyMap(includes, mappingRows);
        String selfRelationColumn = this.getSelfRelationColumn();
        for (RelationExtraEntity entity : this.entities) {
            Object selfRelationId = entity.getRelationExtraColumn(selfRelationColumn);
            Collection targetEntities = targetToManyMap.computeIfAbsent(selfRelationId, k -> this.createManyCollection());
            this.setEntityValue(entity.getEntity(), targetEntities);
        }
    }
}

