/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.parser.core.base.impl;

import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.NavigateInclude;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.IncludeNavigateParams;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyObjectUtil;

public class NavigateIncludeImpl<TEntity>
implements NavigateInclude<TEntity> {
    private final TableAvailable entityTable;
    private final QueryRuntimeContext runtimeContext;
    private final IncludeNavigateParams includeNavigateParams;
    private final ExpressionContext expressionContext;

    public NavigateIncludeImpl(TableAvailable table, QueryRuntimeContext runtimeContext, IncludeNavigateParams includeNavigateParams, ExpressionContext expressionContext) {
        this.entityTable = table;
        this.runtimeContext = runtimeContext;
        this.includeNavigateParams = includeNavigateParams;
        this.expressionContext = expressionContext;
    }

    private NavigateMetadata withBefore(String property, Integer groupSize) {
        if (groupSize != null && groupSize < 1) {
            throw new IllegalArgumentException("include group size < 1");
        }
        NavigateMetadata navigateMetadata = this.entityTable.getEntityMetadata().getNavigateNotNull(property);
        this.includeNavigateParams.setNavigateMetadata(navigateMetadata);
        this.includeNavigateParams.setTable(this.entityTable);
        this.includeNavigateParams.setRelationGroupSize(groupSize);
        RelationTypeEnum relationType = navigateMetadata.getRelationType();
        if (RelationTypeEnum.ManyToMany == relationType) {
            ClientQueryable<?> mappingQuery = this.runtimeContext.getSQLClientApiFactory().createQueryable(navigateMetadata.getMappingClass(), this.runtimeContext);
            ClientQueryable mappingQueryable = mappingQuery.where(t -> {
                t.in(navigateMetadata.getSelfMappingProperty(), this.includeNavigateParams.getRelationIds());
                navigateMetadata.predicateFilterApply((WherePredicate<?>)t);
            }).select(o -> o.column(navigateMetadata.getSelfMappingProperty()).column(navigateMetadata.getTargetMappingProperty()));
            this.includeNavigateParams.setMappingQueryable(mappingQueryable);
        }
        return navigateMetadata;
    }

    @Override
    public IncludeNavigateParams getIncludeNavigateParams() {
        return this.includeNavigateParams;
    }

    @Override
    public <TREntity> ClientQueryable<TREntity> with(String property, Integer groupSize) {
        NavigateMetadata navigateMetadata = this.withBefore(property, groupSize);
        Class<?> navigatePropertyType = navigateMetadata.getNavigatePropertyType();
        boolean tracking = this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.USE_TRACKING);
        ClientQueryable queryable = this.runtimeContext.getSQLClientApiFactory().createQueryable((Class)EasyObjectUtil.typeCastNullable(navigatePropertyType), this.runtimeContext);
        if (tracking) {
            queryable.getSQLEntityExpressionBuilder().getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.USE_TRACKING);
        } else {
            queryable.getSQLEntityExpressionBuilder().getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.USE_TRACKING);
        }
        return queryable;
    }
}

