/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.builder;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLKeywordEnum;
import com.easy.query.core.expression.segment.ReverseOrderBySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.AbstractSQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.OrderBySQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import java.util.List;

public class OrderBySQLBuilderSegmentImpl
extends AbstractSQLBuilderSegment
implements OrderBySQLBuilderSegment {
    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        StringBuilder sb = new StringBuilder();
        List<SQLSegment> sqlSegments = this.getSQLSegments();
        for (int i = sqlSegments.size() - 1; i >= 0; --i) {
            SQLSegment sqlSegment = sqlSegments.get(i);
            if (sb.length() != 0) {
                sb.insert(0, SQLKeywordEnum.DOT.toSQL());
            }
            String orderSQL = sqlSegment.toSQL(toSQLContext);
            if (sb.length() == 0) {
                sb.insert(0, orderSQL);
                continue;
            }
            sb.insert(0, orderSQL);
        }
        return sb.toString();
    }

    @Override
    public SQLBuilderSegment cloneSQLBuilder() {
        OrderBySQLBuilderSegmentImpl orderBySQLBuilderSegment = new OrderBySQLBuilderSegmentImpl();
        this.copyTo(orderBySQLBuilderSegment);
        return orderBySQLBuilderSegment;
    }

    @Override
    public boolean reverseOrder() {
        if (this.getSQLSegments().stream().allMatch(o -> o instanceof ReverseOrderBySegment)) {
            for (SQLSegment sqlSegment : this.getSQLSegments()) {
                ReverseOrderBySegment reverseOrderBySegment = (ReverseOrderBySegment)((Object)sqlSegment);
                reverseOrderBySegment.reverseOrder();
            }
            return true;
        }
        return false;
    }
}

