/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.builder;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLKeywordEnum;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.AbstractSQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.Iterator;
import java.util.List;

public class ProjectSQLBuilderSegmentImpl
extends AbstractSQLBuilderSegment
implements ProjectSQLBuilderSegment {
    private boolean projectHasAggregate = false;

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        StringBuilder sb = new StringBuilder();
        List<SQLSegment> sqlSegments = this.getSQLSegments();
        if (!sqlSegments.isEmpty()) {
            Iterator<SQLSegment> iterator = sqlSegments.iterator();
            SQLSegment first = iterator.next();
            sb.append(first.toSQL(toSQLContext));
            while (iterator.hasNext()) {
                SQLSegment sqlSegment = iterator.next();
                sb.append(SQLKeywordEnum.DOT.toSQL()).append(sqlSegment.toSQL(toSQLContext));
            }
        }
        return sb.toString();
    }

    @Override
    public SQLBuilderSegment cloneSQLBuilder() {
        ProjectSQLBuilderSegmentImpl projectSQLBuilderSegment = new ProjectSQLBuilderSegmentImpl();
        projectSQLBuilderSegment.projectHasAggregate = this.projectHasAggregate;
        this.copyTo(projectSQLBuilderSegment);
        return projectSQLBuilderSegment;
    }

    @Override
    public void append(SQLSegment sqlSegment) {
        boolean aggregateColumn;
        super.append(sqlSegment);
        if (!this.projectHasAggregate && (aggregateColumn = EasySQLSegmentUtil.isAggregateColumn(sqlSegment))) {
            this.projectHasAggregate = true;
        }
    }

    @Override
    public boolean hasAggregateColumns() {
        return this.projectHasAggregate;
    }
}

