/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.DefaultSQLPropertyConverter;
import com.easy.query.core.basic.jdbc.parameter.EasyConstSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ShardingPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuesPredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ColumnCollectionPredicate
implements ValuesPredicate,
ShardingPredicate {
    private final Collection<?> collection;
    private final SQLPredicateCompare compare;
    private final ExpressionContext expressionContext;
    private final TableAvailable table;
    private final String propertyName;

    public ColumnCollectionPredicate(TableAvailable table, String propertyName, Collection<?> collection, SQLPredicateCompare compare, ExpressionContext expressionContext) {
        this.table = table;
        this.propertyName = propertyName;
        this.collection = collection;
        this.compare = compare;
        this.expressionContext = expressionContext;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        if (EasyCollectionUtil.isEmpty(this.collection)) {
            if (SQLPredicateCompareEnum.IN == this.compare) {
                return "1 = 2";
            }
            if (SQLPredicateCompareEnum.NOT_IN == this.compare) {
                return "1 = 1";
            }
            throw new UnsupportedOperationException();
        }
        ColumnMetadata columnMetadata = this.table.getEntityMetadata().getColumnNotNull(this.propertyName);
        String sqlColumnSegment = EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.table, columnMetadata, toSQLContext, true, false);
        String compareSQL = this.compare.getSQL();
        StringBuilder sql = new StringBuilder();
        sql.append(sqlColumnSegment).append(" ").append(compareSQL).append(" (");
        Iterator<?> iterator = this.collection.iterator();
        Object firstVal = iterator.next();
        EasyConstSQLParameter easyConstSQLParameter = new EasyConstSQLParameter(this.table, this.propertyName, firstVal);
        sql.append(this.getSQLParameterSegment(easyConstSQLParameter, columnMetadata, toSQLContext));
        while (iterator.hasNext()) {
            Object val = iterator.next();
            EasyConstSQLParameter constSQLParameter = new EasyConstSQLParameter(this.table, this.propertyName, val);
            sql.append(",").append(this.getSQLParameterSegment(constSQLParameter, columnMetadata, toSQLContext));
        }
        sql.append(")");
        return sql.toString();
    }

    private String getSQLParameterSegment(SQLParameter sqlParameter, ColumnMetadata columnMetadata, ToSQLContext toSQLContext) {
        ColumnValueSQLConverter columnValueSQLConverter = columnMetadata.getColumnValueSQLConverter();
        if (columnValueSQLConverter == null) {
            EasySQLUtil.addParameter(toSQLContext, sqlParameter);
            return "?";
        }
        DefaultSQLPropertyConverter sqlPropertyConverter = new DefaultSQLPropertyConverter(this.table, this.expressionContext);
        columnValueSQLConverter.valueConvert(this.table, columnMetadata, sqlParameter, sqlPropertyConverter, this.expressionContext.getRuntimeContext(), true);
        return sqlPropertyConverter.toSQL(toSQLContext);
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        return new ColumnCollectionPredicate(this.table, this.propertyName, this.collection, this.compare, this.expressionContext);
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }

    @Override
    public Collection<SQLParameter> getParameters() {
        if (EasyCollectionUtil.isEmpty(this.collection)) {
            return Collections.emptyList();
        }
        ArrayList<SQLParameter> sqlParameters = new ArrayList<SQLParameter>(this.collection.size());
        for (Object o : this.collection) {
            sqlParameters.add(new EasyConstSQLParameter(this.table, this.propertyName, o));
        }
        return sqlParameters;
    }
}

