/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.DefaultSQLPropertyConverter;
import com.easy.query.core.basic.jdbc.parameter.PropertySQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuePredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLUtil;

public class ColumnEqualsPropertyPredicate
implements Predicate,
ValuePredicate {
    protected final TableAvailable table;
    protected final String propertyName;
    protected final ExpressionContext expressionContext;

    public ColumnEqualsPropertyPredicate(TableAvailable table, String propertyName, ExpressionContext expressionContext) {
        this.table = table;
        this.propertyName = propertyName;
        this.expressionContext = expressionContext;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        PropertySQLParameter sqlParameter = new PropertySQLParameter(this.table, this.propertyName);
        ColumnMetadata columnMetadata = this.table.getEntityMetadata().getColumnNotNull(this.propertyName);
        ColumnValueSQLConverter columnValueSQLConverter = columnMetadata.getColumnValueSQLConverter();
        String sqlColumnSegment = EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.table, columnMetadata, toSQLContext, true, false);
        if (columnValueSQLConverter == null) {
            EasySQLUtil.addParameter(toSQLContext, sqlParameter);
            return sqlColumnSegment + " = ?";
        }
        DefaultSQLPropertyConverter sqlValueConverter = new DefaultSQLPropertyConverter(this.table, this.expressionContext);
        columnValueSQLConverter.valueConvert(this.table, columnMetadata, sqlParameter, sqlValueConverter, this.expressionContext.getRuntimeContext(), true);
        String valSQLParameter = sqlValueConverter.toSQL(toSQLContext);
        return sqlColumnSegment + " = " + valSQLParameter;
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return SQLPredicateCompareEnum.EQ;
    }

    @Override
    public SQLParameter getParameter() {
        return new PropertySQLParameter(this.table, this.propertyName);
    }
}

