/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.DefaultSQLPropertyConverter;
import com.easy.query.core.basic.jdbc.parameter.ConstLikeSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.EasyConstSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ShardingPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuePredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLUtil;

public class ColumnValuePredicate
implements ValuePredicate,
ShardingPredicate {
    private final TableAvailable table;
    private final ColumnMetadata columnMetadata;
    private final Object val;
    private final SQLPredicateCompare compare;
    private final ExpressionContext expressionContext;

    public ColumnValuePredicate(TableAvailable table, ColumnMetadata columnMetadata, Object val, SQLPredicateCompare compare, ExpressionContext expressionContext) {
        this.table = table;
        this.columnMetadata = columnMetadata;
        this.val = val;
        this.compare = compare;
        this.expressionContext = expressionContext;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        SQLParameter sqlParameter = this.getParameter();
        ColumnValueSQLConverter columnValueSQLConverter = this.columnMetadata.getColumnValueSQLConverter();
        String sqlColumnSegment = EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.table, this.columnMetadata, toSQLContext, true, false);
        if (columnValueSQLConverter == null) {
            EasySQLUtil.addParameter(toSQLContext, sqlParameter);
            return sqlColumnSegment + " " + this.compare.getSQL() + " ?";
        }
        DefaultSQLPropertyConverter sqlValueConverter = new DefaultSQLPropertyConverter(this.table, this.expressionContext);
        columnValueSQLConverter.valueConvert(this.table, this.columnMetadata, sqlParameter, sqlValueConverter, this.expressionContext.getRuntimeContext(), true);
        String valSQLParameter = sqlValueConverter.toSQL(toSQLContext);
        return sqlColumnSegment + " " + this.compare.getSQL() + " " + valSQLParameter;
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public String getPropertyName() {
        return this.columnMetadata.getPropertyName();
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        return new ColumnValuePredicate(this.table, this.columnMetadata, this.val, this.compare, this.expressionContext);
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }

    @Override
    public SQLParameter getParameter() {
        EasyConstSQLParameter constSQLParameter = new EasyConstSQLParameter(this.table, this.columnMetadata.getPropertyName(), this.val);
        if (SQLPredicateCompareEnum.LIKE == this.compare || SQLPredicateCompareEnum.NOT_LIKE == this.compare) {
            return new ConstLikeSQLParameter(constSQLParameter);
        }
        return constSQLParameter;
    }
}

