/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasySQLExpressionUtil;

public class ColumnWithColumnPredicate
implements Predicate {
    private final TableAvailable leftTable;
    private final String leftPropertyName;
    private final TableAvailable rightTable;
    private final String rightPropertyName;
    private final SQLPredicateCompare compare;
    private final ExpressionContext expressionContext;

    public ColumnWithColumnPredicate(TableAvailable leftTable, String leftPropertyName, TableAvailable rightTable, String rightPropertyName, SQLPredicateCompare compare, ExpressionContext expressionContext) {
        this.leftTable = leftTable;
        this.leftPropertyName = leftPropertyName;
        this.rightTable = rightTable;
        this.rightPropertyName = rightPropertyName;
        this.compare = compare;
        this.expressionContext = expressionContext;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        ColumnMetadata leftColumnMetadata = this.leftTable.getEntityMetadata().getColumnNotNull(this.leftPropertyName);
        String sqlColumnSegment1 = EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.leftTable, leftColumnMetadata, toSQLContext, true, false);
        ColumnMetadata rightColumnMetadata = this.rightTable.getEntityMetadata().getColumnNotNull(this.rightPropertyName);
        String sqlColumnSegment2 = EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.rightTable, rightColumnMetadata, toSQLContext, true, false);
        return sqlColumnSegment1 + " " + this.compare.getSQL() + " " + sqlColumnSegment2;
    }

    @Override
    public TableAvailable getTable() {
        return this.leftTable;
    }

    @Override
    public String getPropertyName() {
        return this.leftPropertyName;
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }
}

