/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.DefaultSQLPropertyConverter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasySQLUtil;

public abstract class AbstractInsertUpdateSetColumnSQLSegmentImpl {
    protected final TableAvailable table;
    protected final String propertyName;
    protected final ExpressionContext expressionContext;
    protected final ColumnMetadata columnMetadata;

    public AbstractInsertUpdateSetColumnSQLSegmentImpl(TableAvailable table, String propertyName, ExpressionContext expressionContext) {
        this(table, table.getEntityMetadata().getColumnNotNull(propertyName), expressionContext);
    }

    public AbstractInsertUpdateSetColumnSQLSegmentImpl(TableAvailable table, ColumnMetadata columnMetadata, ExpressionContext expressionContext) {
        if (columnMetadata.isValueObject()) {
            throw new IllegalArgumentException("entity:[" + EasyClassUtil.getSimpleName(table.getEntityClass()) + "." + columnMetadata.getPropertyName() + "] is value object");
        }
        this.table = table;
        this.propertyName = columnMetadata.getPropertyName();
        this.expressionContext = expressionContext;
        this.columnMetadata = columnMetadata;
    }

    public String toSQLWithParameter(ToSQLContext toSQLContext, SQLParameter sqlParameter) {
        ColumnValueSQLConverter columnValueSQLConverter = this.columnMetadata.getColumnValueSQLConverter();
        if (columnValueSQLConverter == null) {
            EasySQLUtil.addParameter(toSQLContext, sqlParameter);
            return "?";
        }
        DefaultSQLPropertyConverter sqlPropertyConverter = new DefaultSQLPropertyConverter(this.table, this.expressionContext);
        columnValueSQLConverter.valueConvert(this.table, this.columnMetadata, sqlParameter, sqlPropertyConverter, this.expressionContext.getRuntimeContext(), false);
        return sqlPropertyConverter.toSQL(toSQLContext);
    }
}

