/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.scec.context.core.SQLNativeExpression;
import com.easy.query.core.expression.segment.scec.expression.ParamExpression;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import java.text.MessageFormat;

public abstract class AbstractSQLNativeSegmentImpl {
    protected final ExpressionContext expressionContext;
    protected final String sqlSegment;
    protected final SQLNativeExpression sqlNativeExpression;

    public AbstractSQLNativeSegmentImpl(ExpressionContext expressionContext, String sqlSegment, SQLNativeExpression sqlNativeExpression) {
        this.expressionContext = expressionContext;
        this.sqlSegment = sqlSegment;
        this.sqlNativeExpression = sqlNativeExpression;
    }

    public TableAvailable getTable() {
        return this.sqlNativeExpression.getTableOrNull();
    }

    public String getPropertyName() {
        return this.sqlNativeExpression.getPropertyOrNull();
    }

    public String getAlias() {
        return this.sqlNativeExpression.getAlias();
    }

    public String toSQL(ToSQLContext toSQLContext) {
        String resultColumnConst = this.getResultSQL(toSQLContext);
        String alias = this.getAlias();
        if (alias != null) {
            return resultColumnConst + " AS " + EasySQLExpressionUtil.getQuoteName(this.expressionContext.getRuntimeContext(), alias);
        }
        return resultColumnConst;
    }

    private String getResultSQL(ToSQLContext toSQLContext) {
        if (EasyCollectionUtil.isNotEmpty(this.sqlNativeExpression.getExpressions())) {
            Object[] args = new Object[this.sqlNativeExpression.getExpressions().size()];
            for (int i = 0; i < this.sqlNativeExpression.getExpressions().size(); ++i) {
                Object arg;
                ParamExpression paramExpression = this.sqlNativeExpression.getExpressions().get(i);
                args[i] = arg = EasySQLExpressionUtil.parseParamExpression(this.expressionContext, paramExpression, toSQLContext);
            }
            if (this.sqlNativeExpression.isKeepStyle()) {
                return MessageFormat.format(this.sqlSegment.replace("'", "''"), args);
            }
            return MessageFormat.format(this.sqlSegment, args);
        }
        return this.sqlSegment;
    }
}

