/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.jdbc.parameter.EasyConstSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLUtil;

public class ColumnWithSelfSegmentImpl
implements InsertUpdateSetColumnSQLSegment {
    private static final String INCREMENT = "+ ?";
    private static final String DECREMENT = "- ?";
    private final boolean increment;
    private final String propertyName;
    private final Object val;
    private final ExpressionContext expressionContext;
    private final TableAvailable entityTable;

    public ColumnWithSelfSegmentImpl(boolean increment, TableAvailable entityTable, String propertyName, Object val, ExpressionContext expressionContext) {
        this.increment = increment;
        this.entityTable = entityTable;
        this.propertyName = propertyName;
        this.val = val;
        this.expressionContext = expressionContext;
    }

    private String getOperator() {
        return this.increment ? INCREMENT : DECREMENT;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        EasySQLUtil.addParameter(toSQLContext, new EasyConstSQLParameter(this.entityTable, this.propertyName, this.val));
        ColumnMetadata columnMetadata = this.entityTable.getEntityMetadata().getColumnNotNull(this.propertyName);
        String sqlColumnSegment = EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.entityTable, columnMetadata, toSQLContext, true, false);
        return sqlColumnSegment + this.getOperator();
    }

    @Override
    public TableAvailable getTable() {
        return this.entityTable;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getColumnNameWithOwner(ToSQLContext toSQLContext) {
        ColumnMetadata columnMetadata = this.entityTable.getEntityMetadata().getColumnNotNull(this.propertyName);
        return EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.entityTable, columnMetadata, toSQLContext, true, false);
    }

    @Override
    public InsertUpdateSetColumnSQLSegment cloneSQLColumnSegment() {
        return new ColumnWithSelfSegmentImpl(this.increment, this.entityTable, this.propertyName, this.val, this.expressionContext);
    }
}

