/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLKeywordEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.OrderBySegment;
import com.easy.query.core.expression.segment.ReverseOrderBySegment;
import com.easy.query.core.expression.segment.impl.ColumnSegmentImpl;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasySQLExpressionUtil;

public class OrderColumnSegmentImpl
extends ColumnSegmentImpl
implements OrderBySegment,
ReverseOrderBySegment {
    private final boolean asc;
    private boolean reverse;

    public OrderColumnSegmentImpl(TableAvailable table, ColumnMetadata columnMetadata, ExpressionContext expressionContext, boolean asc) {
        super(table, columnMetadata, expressionContext);
        this.asc = asc;
        this.reverse = false;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        String sqlColumnSegment = EasySQLExpressionUtil.getSQLOwnerColumnMetadata(this.expressionContext, this.table, this.columnMetadata, toSQLContext, true, false);
        StringBuilder sql = new StringBuilder().append(sqlColumnSegment);
        if (this.getOrderByAsc()) {
            sql.append(" ").append(SQLKeywordEnum.ASC.toSQL());
        } else {
            sql.append(" ").append(SQLKeywordEnum.DESC.toSQL());
        }
        return sql.toString();
    }

    @Override
    public boolean isAsc() {
        return this.asc;
    }

    private boolean getOrderByAsc() {
        return this.isReverse() != this.isAsc();
    }

    @Override
    protected boolean ignoreAlias() {
        return true;
    }

    @Override
    public void reverseOrder() {
        this.reverse = true;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }
}

