/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.func.AggregationType;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.FuncColumnSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.metadata.ColumnMetadata;

public class SQLFunctionColumnSegmentImpl
implements FuncColumnSegment {
    protected final TableAvailable table;
    protected final ColumnMetadata columnMetadata;
    protected final QueryRuntimeContext runtimeContext;
    private final SQLSegment sqlSegment;
    private final AggregationType aggregationType;
    protected String alias;

    public SQLFunctionColumnSegmentImpl(TableAvailable table, ColumnMetadata columnMetadata, QueryRuntimeContext runtimeContext, SQLSegment sqlSegment, AggregationType aggregationType, String alias) {
        this.table = table;
        this.columnMetadata = columnMetadata;
        this.runtimeContext = runtimeContext;
        this.sqlSegment = sqlSegment;
        this.aggregationType = aggregationType;
        this.alias = alias;
    }

    @Override
    public ColumnMetadata getColumnMetadata() {
        return this.columnMetadata;
    }

    @Override
    public FuncColumnSegment cloneSQLColumnSegment() {
        return new SQLFunctionColumnSegmentImpl(this.table, this.columnMetadata, this.runtimeContext, this.sqlSegment, this.aggregationType, this.alias);
    }

    @Override
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        return this.sqlSegment.toSQL(toSQLContext);
    }

    @Override
    public String getPropertyName() {
        return this.columnMetadata.getPropertyName();
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }
}

