/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql;

import com.easy.query.core.exception.EasyQueryTableNotInSQLContextException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.TableAliasSchema;
import com.easy.query.core.expression.sql.ToTableContext;
import com.easy.query.core.util.EasyClassUtil;
import java.util.HashMap;
import java.util.Map;

public final class MultiToTableContext
implements ToTableContext {
    private final HashMap<TableAvailable, String> aliasMapping;
    private final boolean firstHasAlias;
    private final String defaultAlias;
    private final Map<TableAvailable, TableAliasSchema> lazyAliasMapping;

    public MultiToTableContext(HashMap<TableAvailable, String> aliasMapping, boolean firstHasAlias, String defaultAlias, Map<TableAvailable, TableAliasSchema> lazyAliasMapping) {
        this.aliasMapping = aliasMapping;
        this.firstHasAlias = firstHasAlias;
        this.defaultAlias = defaultAlias;
        this.lazyAliasMapping = lazyAliasMapping;
    }

    @Override
    public String getAlias(TableAvailable table) {
        if (!this.aliasMapping.containsKey(table)) {
            TableAliasSchema lazyTableSchema = this.lazyAliasMapping.get(table);
            if (lazyTableSchema != null) {
                return lazyTableSchema.getTableAlias(this.defaultAlias);
            }
            throw new EasyQueryTableNotInSQLContextException("not found table:[" + EasyClassUtil.getSimpleName(table.getEntityClass()) + "] in sql context");
        }
        return this.aliasMapping.get(table);
    }
}

