/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder;

import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.configuration.QueryConfiguration;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.expression.builder.core.AnyValueFilter;
import com.easy.query.core.expression.builder.core.ValueFilter;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.TableContext;
import com.easy.query.core.expression.sql.builder.ExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.internal.EasyBehavior;
import com.easy.query.core.expression.sql.builder.internal.ExpressionContextInterceptor;
import com.easy.query.core.expression.sql.include.ColumnIncludeExpression;
import com.easy.query.core.metadata.IncludeNavigateExpression;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.metadata.RelationExtraMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class EasyExpressionContext
implements ExpressionContext {
    private final QueryRuntimeContext runtimeContext;
    protected final EasyBehavior easyBehavior;
    protected final ExpressionContextInterceptor expressionContextInterceptor;
    protected final TableContext tableContext;
    private boolean deleteThrowException;
    private Object version;
    private ExecuteMethodEnum executeMethod = ExecuteMethodEnum.UNKNOWN;
    private SQLExecuteStrategyEnum sqlStrategy = SQLExecuteStrategyEnum.DEFAULT;
    private Integer maxShardingQueryLimit;
    private ConnectionModeEnum connectionMode;
    private boolean sharding;
    private boolean hasSubQuery;
    private ValueFilter valueFilter;
    private Map<NavigateMetadata, IncludeNavigateExpression> includes;
    private List<ExpressionBuilder> declareExpressions;
    private Consumer<Object> forEachConfigurer;
    private Map<TableAvailable, Map<String, ColumnIncludeExpression>> columnIncludeMaps;
    private ResultColumnMetadata[] propTypes;
    private Function<Class<?>, Boolean> relationLogicDelete;
    private RelationExtraMetadata relationExtraMetadata;

    public EasyExpressionContext(QueryRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
        QueryConfiguration queryConfiguration = runtimeContext.getQueryConfiguration();
        this.deleteThrowException = queryConfiguration.deleteThrow();
        this.easyBehavior = new EasyBehavior();
        EasyQueryOption easyQueryOption = queryConfiguration.getEasyQueryOption();
        if (!easyQueryOption.isQueryLargeColumn()) {
            this.easyBehavior.removeBehavior(EasyBehaviorEnum.QUERY_LARGE_COLUMN);
        }
        if (easyQueryOption.isDefaultTrack()) {
            this.easyBehavior.addBehavior(EasyBehaviorEnum.USE_TRACKING);
        }
        this.expressionContextInterceptor = new ExpressionContextInterceptor();
        this.tableContext = new TableContext();
        this.maxShardingQueryLimit = null;
        this.connectionMode = null;
        this.sharding = false;
        this.valueFilter = AnyValueFilter.DEFAULT;
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public String getQuoteName(String value) {
        return this.runtimeContext.getQueryConfiguration().getDialect().getQuoteName(value);
    }

    @Override
    public void deleteThrow(boolean ifDeleteThrowException) {
        this.deleteThrowException = ifDeleteThrowException;
    }

    @Override
    public boolean isDeleteThrow() {
        return this.deleteThrowException;
    }

    @Override
    public EasyBehavior getBehavior() {
        return this.easyBehavior;
    }

    @Override
    public void useSQLStrategy(SQLExecuteStrategyEnum sqlStrategy) {
        this.sqlStrategy = sqlStrategy;
    }

    @Override
    public SQLExecuteStrategyEnum getSQLStrategy() {
        return this.sqlStrategy;
    }

    @Override
    public Object getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Object version) {
        this.version = version;
    }

    @Override
    public void useInterceptor(String name) {
        this.expressionContextInterceptor.useInterceptor(name);
    }

    @Override
    public void noInterceptor(String name) {
        this.expressionContextInterceptor.noInterceptor(name);
    }

    @Override
    public void useInterceptor() {
        this.expressionContextInterceptor.useInterceptor();
        this.getBehavior().addBehavior(EasyBehaviorEnum.USE_INTERCEPTOR);
    }

    @Override
    public void noInterceptor() {
        this.expressionContextInterceptor.noInterceptor();
        this.getBehavior().removeBehavior(EasyBehaviorEnum.USE_INTERCEPTOR);
    }

    @Override
    public Predicate<Interceptor> getInterceptorFilter() {
        boolean interceptorBehavior = this.getBehavior().hasBehavior(EasyBehaviorEnum.USE_INTERCEPTOR);
        return o -> {
            if (interceptorBehavior) {
                return this.expressionContextInterceptor.useContains(o.name()) || !this.expressionContextInterceptor.noContains(o.name()) && o.enable();
            }
            return this.expressionContextInterceptor.useContains(o.name()) && !this.expressionContextInterceptor.noContains(o.name());
        };
    }

    @Override
    public void executeMethod(ExecuteMethodEnum executeMethod, boolean ifUnknown) {
        if (ifUnknown) {
            if (Objects.equals((Object)ExecuteMethodEnum.UNKNOWN, (Object)this.executeMethod)) {
                this.executeMethod = executeMethod;
            }
        } else {
            this.executeMethod = executeMethod;
        }
    }

    @Override
    public ExecuteMethodEnum getExecuteMethod() {
        return this.executeMethod;
    }

    @Override
    public void setMaxShardingQueryLimit(int maxShardingQueryLimit) {
        this.maxShardingQueryLimit = maxShardingQueryLimit;
    }

    @Override
    public Integer getMaxShardingQueryLimitOrNull() {
        return this.maxShardingQueryLimit;
    }

    @Override
    public void setConnectionMode(ConnectionModeEnum connectionMode) {
        this.connectionMode = connectionMode;
    }

    @Override
    public ConnectionModeEnum getConnectionModeOrNull() {
        return this.connectionMode;
    }

    @Override
    public void useSharding() {
        this.sharding = true;
    }

    @Override
    public boolean isSharding() {
        return this.sharding;
    }

    @Override
    public void extract(ExpressionContext otherExpressionContext) {
        if (otherExpressionContext.isSharding()) {
            this.sharding = true;
        }
        this.hasSubQuery = true;
        this.tableContext.extract(otherExpressionContext.getTableContext());
        if (otherExpressionContext.hasDeclareExpressions()) {
            for (ExpressionBuilder declareExpression : otherExpressionContext.getDeclareExpressions()) {
                this.getDeclareExpressions().add(declareExpression);
            }
        }
    }

    @Override
    public boolean hasSubQuery() {
        return this.hasSubQuery;
    }

    @Override
    public Map<NavigateMetadata, IncludeNavigateExpression> getIncludes() {
        if (this.includes == null) {
            this.includes = new LinkedHashMap<NavigateMetadata, IncludeNavigateExpression>();
        }
        return this.includes;
    }

    @Override
    public boolean hasIncludes() {
        return this.includes != null && !this.includes.isEmpty();
    }

    @Override
    public Map<TableAvailable, Map<String, ColumnIncludeExpression>> getColumnIncludeMaps() {
        if (this.columnIncludeMaps == null) {
            this.columnIncludeMaps = new HashMap<TableAvailable, Map<String, ColumnIncludeExpression>>();
        }
        return this.columnIncludeMaps;
    }

    @Override
    public boolean hasColumnIncludeMaps() {
        return this.columnIncludeMaps != null && !this.columnIncludeMaps.isEmpty();
    }

    @Override
    public void filterConfigure(ValueFilter valueFilter) {
        Objects.requireNonNull(valueFilter, "valueFilter can not be null");
        this.valueFilter = valueFilter;
    }

    @Override
    public ValueFilter getValueFilter() {
        return this.valueFilter;
    }

    @Override
    public Consumer<Object> getForEachConfigurer() {
        return this.forEachConfigurer;
    }

    @Override
    public void setForEachConfigurer(Consumer<Object> forEachConfigurer) {
        this.forEachConfigurer = forEachConfigurer;
    }

    @Override
    public TableContext getTableContext() {
        return this.tableContext;
    }

    @Override
    public ExpressionContext cloneExpressionContext() {
        EasyExpressionContext easyExpressionContext = new EasyExpressionContext(this.runtimeContext);
        this.easyBehavior.copyTo(easyExpressionContext.easyBehavior);
        this.expressionContextInterceptor.copyTo(easyExpressionContext.expressionContextInterceptor);
        this.tableContext.copyTo(easyExpressionContext.tableContext);
        easyExpressionContext.deleteThrowException = this.deleteThrowException;
        easyExpressionContext.version = this.version;
        easyExpressionContext.executeMethod = this.executeMethod;
        easyExpressionContext.sqlStrategy = this.sqlStrategy;
        easyExpressionContext.maxShardingQueryLimit = this.maxShardingQueryLimit;
        easyExpressionContext.connectionMode = this.connectionMode;
        easyExpressionContext.sharding = this.sharding;
        easyExpressionContext.hasSubQuery = this.hasSubQuery;
        easyExpressionContext.relationExtraMetadata = this.relationExtraMetadata;
        if (this.hasIncludes()) {
            easyExpressionContext.getIncludes().putAll(this.includes);
        }
        if (this.hasColumnIncludeMaps()) {
            easyExpressionContext.getColumnIncludeMaps().putAll(this.columnIncludeMaps);
        }
        if (this.propTypes != null) {
            easyExpressionContext.propTypes = new ResultColumnMetadata[this.propTypes.length];
            System.arraycopy(this.propTypes, 0, easyExpressionContext.propTypes, 0, this.propTypes.length);
        }
        return easyExpressionContext;
    }

    @Override
    public List<ExpressionBuilder> getDeclareExpressions() {
        if (this.declareExpressions == null) {
            this.declareExpressions = new ArrayList<ExpressionBuilder>();
        }
        return this.declareExpressions;
    }

    @Override
    public boolean hasDeclareExpressions() {
        return EasyCollectionUtil.isNotEmpty(this.declareExpressions);
    }

    @Override
    public void setResultPropTypes(ResultColumnMetadata[] propTypes) {
        this.propTypes = propTypes;
    }

    @Override
    public ResultColumnMetadata[] getResultPropTypes() {
        return this.propTypes;
    }

    @Override
    public void setRelationLogicDelete(Function<Class<?>, Boolean> relationLogicDelete) {
        this.relationLogicDelete = relationLogicDelete;
    }

    @Override
    public boolean hasRelationLogicDelete() {
        return this.relationLogicDelete != null;
    }

    @Override
    public Function<Class<?>, Boolean> getRelationLogicDelete() {
        return this.relationLogicDelete;
    }

    @Override
    public RelationExtraMetadata getRelationExtraMetadata() {
        if (this.relationExtraMetadata == null) {
            this.relationExtraMetadata = new RelationExtraMetadata();
        }
        return this.relationExtraMetadata;
    }

    @Override
    public boolean hasRelationExtraMetadata() {
        return this.relationExtraMetadata != null && !this.relationExtraMetadata.getRelationExtraColumnMap().isEmpty();
    }
}

