/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.segment.impl.InsertUpdateColumnConfigureSegmentImpl;
import com.easy.query.core.expression.sql.builder.ColumnConfigurerContext;
import com.easy.query.core.expression.sql.builder.EntityInsertExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.internal.AbstractEntityExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityInsertSQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.util.EasyBeanUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InsertExpressionBuilder
extends AbstractEntityExpressionBuilder
implements EntityInsertExpressionBuilder {
    protected final SQLBuilderSegment columns = new ProjectSQLBuilderSegmentImpl();
    protected Collection<String> duplicateKeys;
    protected SQLBuilderSegment duplicateKeyUpdateColumns;
    protected Map<String, ColumnConfigurerContext> columnConfigurers;

    public InsertExpressionBuilder(ExpressionContext expressionContext, Class<?> entityClass) {
        super(expressionContext, entityClass);
    }

    @Override
    public SQLBuilderSegment getColumns() {
        return this.columns;
    }

    @Override
    public SQLBuilderSegment getDuplicateKeyUpdateColumns() {
        if (this.duplicateKeyUpdateColumns == null) {
            this.duplicateKeyUpdateColumns = new ProjectSQLBuilderSegmentImpl();
        }
        return this.duplicateKeyUpdateColumns;
    }

    @Override
    public Collection<String> getDuplicateKeys() {
        return this.duplicateKeys;
    }

    @Override
    public void addDuplicateKey(String duplicateKey) {
        if (this.duplicateKeys == null) {
            this.duplicateKeys = new ArrayList<String>();
        }
        if (!this.duplicateKeys.contains(duplicateKey)) {
            this.duplicateKeys.add(duplicateKey);
        }
    }

    private void checkTable() {
        int tableCount = this.getTables().size();
        if (tableCount == 0) {
            throw new EasyQueryException("not found any table in delete expression build.");
        }
        if (tableCount > 1) {
            throw new EasyQueryInvalidOperationException("not support multi table in delete expression build.");
        }
    }

    private boolean clearIgnoreProperties(Set<String> ignorePropertySet, QueryRuntimeContext runtimeContext, Object entity) {
        if (entity != null) {
            SQLExecuteStrategyEnum insertStrategy = this.expressionContext.getSQLStrategy();
            if (Objects.equals((Object)SQLExecuteStrategyEnum.DEFAULT, (Object)insertStrategy)) {
                SQLExecuteStrategyEnum globalInsertStrategy = runtimeContext.getQueryConfiguration().getEasyQueryOption().getInsertStrategy();
                this.getCustomIgnoreProperties(ignorePropertySet, globalInsertStrategy, runtimeContext.getEntityMetadataManager(), entity);
                return true;
            }
            this.getCustomIgnoreProperties(ignorePropertySet, insertStrategy, runtimeContext.getEntityMetadataManager(), entity);
            return true;
        }
        return false;
    }

    private void getCustomIgnoreProperties(Set<String> ignoreUpdateSet, SQLExecuteStrategyEnum updateStrategy, EntityMetadataManager entityMetadataManager, Object entity) {
        if (Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) || Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NULL_COLUMNS, (Object)updateStrategy)) {
            Set<String> beanMatchProperties = EasyBeanUtil.getBeanMatchProperties(entityMetadataManager, entity, Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) ? Objects::isNull : Objects::nonNull);
            ignoreUpdateSet.addAll(beanMatchProperties);
        }
    }

    @Override
    public EntityInsertSQLExpression toExpression(Object entity) {
        int insertColumns;
        boolean hasConfigure;
        this.checkTable();
        EntityTableExpressionBuilder table = this.getTable(0);
        QueryRuntimeContext runtimeContext = this.getRuntimeContext();
        ExpressionFactory expressionFactory = runtimeContext.getExpressionFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, runtimeContext);
        EntityInsertSQLExpression easyInsertSQLExpression = expressionFactory.createEasyInsertSQLExpression(entitySQLExpressionMetadata, table.toExpression());
        EntityMetadata entityMetadata = table.getEntityMetadata();
        SQLBuilderSegment insertCloneColumns = this.getColumns().cloneSQLBuilder();
        boolean bl = hasConfigure = this.columnConfigurers != null && !this.columnConfigurers.isEmpty();
        if (insertCloneColumns.isEmpty()) {
            SQLSegmentFactory sqlSegmentFactory = runtimeContext.getSQLSegmentFactory();
            Collection<String> properties = table.getEntityMetadata().getProperties();
            for (String property : properties) {
                ColumnConfigurerContext columnConfigurerContext;
                ColumnMetadata columnMetadata = table.getEntityMetadata().getColumnNotNull(property);
                if (columnMetadata.isValueObject()) continue;
                InsertUpdateSetColumnSQLSegment columnInsertSegment = sqlSegmentFactory.createInsertColumnSegment(table.getEntityTable(), columnMetadata, this.getExpressionContext());
                if (hasConfigure && (columnConfigurerContext = this.columnConfigurers.get(property)) != null) {
                    insertCloneColumns.append(new InsertUpdateColumnConfigureSegmentImpl(columnInsertSegment, this.getExpressionContext(), columnConfigurerContext.getSqlSegment(), columnConfigurerContext.getSqlNativeExpressionContext()));
                    continue;
                }
                insertCloneColumns.append(columnInsertSegment);
            }
            HashSet<String> ignorePropertySet = new HashSet<String>(entityMetadata.getProperties().size());
            boolean clearIgnoreProperties = this.clearIgnoreProperties(ignorePropertySet, this.getRuntimeContext(), entity);
            insertCloneColumns.getSQLSegments().removeIf(o -> {
                if (o instanceof SQLEntitySegment) {
                    SQLEntitySegment sqlEntitySegment = (SQLEntitySegment)o;
                    String propertyName = sqlEntitySegment.getPropertyName();
                    ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(propertyName);
                    if (columnMetadata.isGeneratedKey()) {
                        return columnMetadata.getGeneratedSQLColumnGenerator() == null;
                    }
                    if (columnMetadata.isInsertIgnore()) {
                        return true;
                    }
                    if (clearIgnoreProperties) {
                        return ignorePropertySet.contains(propertyName);
                    }
                }
                return false;
            });
        }
        if ((insertColumns = insertCloneColumns.getSQLSegments().size()) == 0) {
            throw new EasyQueryException("not found insert columns :" + EasyClassUtil.getSimpleName(table.getEntityClass()));
        }
        insertCloneColumns.copyTo(easyInsertSQLExpression.getColumns());
        if (this.duplicateKeys != null) {
            for (String duplicateKey : this.duplicateKeys) {
                easyInsertSQLExpression.addDuplicateKey(duplicateKey);
            }
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.duplicateKeyUpdateColumns)) {
            this.duplicateKeyUpdateColumns.copyTo(easyInsertSQLExpression.getDuplicateKeyUpdateColumns());
        }
        return easyInsertSQLExpression;
    }

    @Override
    public EntityInsertExpressionBuilder cloneEntityExpressionBuilder() {
        EntityInsertExpressionBuilder insertExpressionBuilder = this.runtimeContext.getExpressionBuilderFactory().createEntityInsertExpressionBuilder(this.expressionContext, this.queryClass);
        if (EasySQLSegmentUtil.isNotEmpty(this.getColumns())) {
            this.getColumns().copyTo(insertExpressionBuilder.getColumns());
        }
        if (this.duplicateKeys != null) {
            for (String duplicateKey : this.duplicateKeys) {
                insertExpressionBuilder.addDuplicateKey(duplicateKey);
            }
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.duplicateKeyUpdateColumns)) {
            this.duplicateKeyUpdateColumns.copyTo(insertExpressionBuilder.getDuplicateKeyUpdateColumns());
        }
        for (EntityTableExpressionBuilder table : this.tables) {
            insertExpressionBuilder.getTables().add(table.copyEntityTableExpressionBuilder());
        }
        if (this.columnConfigurers != null) {
            insertExpressionBuilder.getColumnConfigurer().putAll(this.columnConfigurers);
        }
        return insertExpressionBuilder;
    }

    @Override
    public Map<String, ColumnConfigurerContext> getColumnConfigurer() {
        if (this.columnConfigurers == null) {
            this.columnConfigurers = new HashMap<String, ColumnConfigurerContext>();
        }
        return this.columnConfigurers;
    }
}

