/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl;

import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.extension.interceptor.UpdateSetInterceptor;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.EntityTrackProperty;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.basic.extension.version.VersionStrategy;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.ColumnSetter;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.UpdateSetSQLBuilderSegment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.ColumnEqualsPropertyPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnEqualsTrackPropertyPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnNullAssertPredicate;
import com.easy.query.core.expression.segment.impl.ColumnVersionPropertySegmentImpl;
import com.easy.query.core.expression.segment.impl.InsertUpdateColumnConfigureSegmentImpl;
import com.easy.query.core.expression.segment.impl.UpdateColumnSegmentImpl;
import com.easy.query.core.expression.segment.index.SegmentIndex;
import com.easy.query.core.expression.sql.builder.ColumnConfigurerContext;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityUpdateExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.impl.EntityPredicateValue;
import com.easy.query.core.expression.sql.builder.impl.ignore.EntityUpdateSetProcessor;
import com.easy.query.core.expression.sql.builder.internal.AbstractPredicateEntityExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityUpdateSQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.VersionMetadata;
import com.easy.query.core.util.EasyBeanUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class UpdateExpressionBuilder
extends AbstractPredicateEntityExpressionBuilder
implements EntityUpdateExpressionBuilder {
    protected final boolean isExpressionUpdate;
    protected SQLBuilderSegment setColumns;
    protected PredicateSegment where;
    protected SQLBuilderSegment setIgnoreColumns;
    protected SQLBuilderSegment whereColumns;
    protected Map<String, ColumnConfigurerContext> columnConfigurers;

    public UpdateExpressionBuilder(ExpressionContext queryExpressionContext, Class<?> queryClass, boolean isExpressionUpdate) {
        super(queryExpressionContext, queryClass);
        this.isExpressionUpdate = isExpressionUpdate;
    }

    @Override
    public boolean isExpression() {
        return this.isExpressionUpdate;
    }

    @Override
    public SQLBuilderSegment getSetColumns() {
        if (this.setColumns == null) {
            this.setColumns = new UpdateSetSQLBuilderSegment();
        }
        return this.setColumns;
    }

    @Override
    public boolean hasSetColumns() {
        return this.setColumns != null && this.setColumns.isNotEmpty();
    }

    @Override
    public boolean hasWhere() {
        return this.where != null && this.where.isNotEmpty();
    }

    @Override
    public PredicateSegment getWhere() {
        if (this.where == null) {
            this.where = new AndPredicateSegment(true);
        }
        return this.where;
    }

    @Override
    public SQLBuilderSegment getSetIgnoreColumns() {
        if (this.setIgnoreColumns == null) {
            this.setIgnoreColumns = new UpdateSetSQLBuilderSegment();
        }
        return this.setIgnoreColumns;
    }

    @Override
    public boolean hasSetIgnoreColumns() {
        return this.setIgnoreColumns != null && this.setIgnoreColumns.isNotEmpty();
    }

    @Override
    public SQLBuilderSegment getWhereColumns() {
        if (this.whereColumns == null) {
            this.whereColumns = new ProjectSQLBuilderSegmentImpl();
        }
        return this.whereColumns;
    }

    @Override
    public Map<String, ColumnConfigurerContext> getColumnConfigurer() {
        if (this.columnConfigurers == null) {
            this.columnConfigurers = new HashMap<String, ColumnConfigurerContext>();
        }
        return this.columnConfigurers;
    }

    private void checkTable() {
        int tableCount = this.getTables().size();
        if (tableCount == 0) {
            throw new EasyQueryException("not found any table in delete expression build.");
        }
        if (tableCount > 1) {
            throw new EasyQueryInvalidOperationException("not support multi table in delete expression build.");
        }
    }

    @Override
    public EntityUpdateSQLExpression toExpression() {
        if (this.isExpressionUpdate) {
            return this.toUpdateExpression();
        }
        return this.toExpression(null);
    }

    @Override
    public EntityUpdateSQLExpression toExpression(Object entity) {
        this.checkTable();
        EntityTableExpressionBuilder entityTableExpressionBuilder = this.getTables().get(0);
        return this.entityToExpression(entity, entityTableExpressionBuilder);
    }

    private EntityUpdateSQLExpression toUpdateExpression() {
        this.checkTable();
        if (EasySQLSegmentUtil.isEmpty(this.where)) {
            throw new EasyQueryException("'UPDATE' statement without 'WHERE'");
        }
        EntityTableExpressionBuilder tableExpressionBuilder = this.getTable(0);
        SQLBuilderSegment updateSetSQLSegment = this.buildSetSQLSegment(tableExpressionBuilder);
        PredicateSegment sqlWhere = this.sqlPredicateFilter(tableExpressionBuilder, this.where);
        ExpressionFactory expressionFactory = this.runtimeContext.getExpressionFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, this.runtimeContext);
        EntityUpdateSQLExpression easyUpdateSQLExpression = expressionFactory.createEasyUpdateSQLExpression(entitySQLExpressionMetadata, tableExpressionBuilder.toExpression());
        updateSetSQLSegment.copyTo(easyUpdateSQLExpression.getSetColumns());
        sqlWhere.copyTo(easyUpdateSQLExpression.getWhere());
        return easyUpdateSQLExpression;
    }

    protected SQLBuilderSegment buildSetSQLSegment(EntityTableExpressionBuilder table) {
        boolean ignoreVersion;
        EntityMetadata entityMetadata = table.getEntityMetadata();
        SQLBuilderSegment updateSet = this.getSetColumns().cloneSQLBuilder();
        ColumnSetter<Object> sqlColumnSetter = this.getRuntimeContext().getSQLExpressionInvokeFactory().createColumnSetter(table.getEntityTable(), this, updateSet);
        List<UpdateSetInterceptor> updateSetInterceptors = entityMetadata.getUpdateSetInterceptors();
        if (EasyCollectionUtil.isNotEmpty(updateSetInterceptors)) {
            Predicate<Interceptor> interceptorFilter = this.getExpressionContext().getInterceptorFilter();
            for (UpdateSetInterceptor updateSetInterceptor : updateSetInterceptors) {
                if (!interceptorFilter.test(updateSetInterceptor)) continue;
                updateSetInterceptor.configure(entityMetadata.getEntityClass(), this, sqlColumnSetter);
            }
        }
        if (entityMetadata.hasVersionColumn() && !(ignoreVersion = this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.IGNORE_VERSION))) {
            Object version = this.expressionContext.getVersion();
            if (Objects.nonNull(version)) {
                VersionMetadata versionMetadata = entityMetadata.getVersionMetadata();
                String propertyName = versionMetadata.getPropertyName();
                VersionStrategy easyVersionStrategy = versionMetadata.getEasyVersionStrategy();
                Object newVersionValue = easyVersionStrategy.nextVersion(entityMetadata, propertyName, version);
                sqlColumnSetter.set(propertyName, newVersionValue);
            } else {
                throw new EasyQueryInvalidOperationException("entity:" + EasyClassUtil.getSimpleName(table.getEntityClass()) + " has version expression not found version");
            }
        }
        return updateSet;
    }

    public EntityUpdateSQLExpression entityToExpression(Object entity, EntityTableExpressionBuilder tableExpressionBuilder) {
        EntityUpdateSetProcessor entityUpdateSetProcessor;
        TrackManager trackManager = this.expressionContext.getRuntimeContext().getTrackManager();
        TrackContext trackContext = trackManager.getCurrentTrackContext();
        PredicateSegment where = this.buildPropertyWhere(tableExpressionBuilder, entity, trackContext, entityUpdateSetProcessor = new EntityUpdateSetProcessor(entity, this.expressionContext));
        if (EasySQLSegmentUtil.isEmpty(where)) {
            throw new EasyQueryException("'UPDATE' statement without 'WHERE'");
        }
        PredicateSegment sqlWhere = this.sqlPredicateFilter(tableExpressionBuilder, where);
        SQLBuilderSegment updateSet = this.updateSetConfigurer(this.getUpdateSetSegment(sqlWhere, entity, tableExpressionBuilder, entityUpdateSetProcessor));
        ExpressionFactory expressionFactory = this.runtimeContext.getExpressionFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, this.runtimeContext);
        EntityUpdateSQLExpression easyUpdateSQLExpression = expressionFactory.createEasyUpdateSQLExpression(entitySQLExpressionMetadata, tableExpressionBuilder.toExpression());
        updateSet.copyTo(easyUpdateSQLExpression.getSetColumns());
        sqlWhere.copyTo(easyUpdateSQLExpression.getWhere());
        return easyUpdateSQLExpression;
    }

    private SQLBuilderSegment updateSetConfigurer(SQLBuilderSegment updateSet) {
        boolean hasConfigure;
        boolean bl = hasConfigure = this.columnConfigurers != null && !this.columnConfigurers.isEmpty();
        if (!hasConfigure) {
            return updateSet;
        }
        int size = updateSet.getSQLSegments().size();
        for (int i = 0; i < size; ++i) {
            InsertUpdateSetColumnSQLSegment sqlSegment = (InsertUpdateSetColumnSQLSegment)updateSet.getSQLSegments().get(i);
            ColumnConfigurerContext columnConfigurerContext = this.columnConfigurers.get(sqlSegment.getPropertyName());
            if (columnConfigurerContext == null) continue;
            updateSet.getSQLSegments().set(i, new InsertUpdateColumnConfigureSegmentImpl(sqlSegment, this.getExpressionContext(), columnConfigurerContext.getSqlSegment(), columnConfigurerContext.getSqlNativeExpressionContext()));
        }
        return updateSet;
    }

    protected SQLBuilderSegment getUpdateSetSegment(PredicateSegment sqlWhere, Object entity, EntityTableExpressionBuilder tableExpressionBuilder, EntityUpdateSetProcessor entityUpdateSetProcessor) {
        if (EasySQLSegmentUtil.isNotEmpty(this.setColumns)) {
            SQLBuilderSegment sqlSetBuilderSegment = this.setColumns.cloneSQLBuilder();
            TableAvailable entityTable = tableExpressionBuilder.getEntityTable();
            return this.processVersionColumn(sqlSetBuilderSegment, entityTable);
        }
        return this.buildUpdateSetByWhere(sqlWhere, entity, tableExpressionBuilder, entityUpdateSetProcessor);
    }

    protected SQLBuilderSegment processVersionColumn(SQLBuilderSegment sqlSetBuilderSegment, TableAvailable entityTable) {
        boolean ignoreVersion;
        EntityMetadata entityMetadata = entityTable.getEntityMetadata();
        if (entityMetadata.hasVersionColumn() && !(ignoreVersion = this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.IGNORE_VERSION))) {
            VersionMetadata versionMetadata = entityMetadata.getVersionMetadata();
            VersionStrategy easyVersionStrategy = versionMetadata.getEasyVersionStrategy();
            sqlSetBuilderSegment.append(new ColumnVersionPropertySegmentImpl(entityTable, versionMetadata.getPropertyName(), easyVersionStrategy, this.getExpressionContext()));
        }
        return sqlSetBuilderSegment;
    }

    protected SQLBuilderSegment buildUpdateSetByWhere(PredicateSegment sqlWhere, Object entity, EntityTableExpressionBuilder tableExpressionBuilder, EntityUpdateSetProcessor entityUpdateSetProcessor) {
        UpdateSetSQLBuilderSegment updateSetSQLBuilderSegment = new UpdateSetSQLBuilderSegment();
        TableAvailable entityTable = tableExpressionBuilder.getEntityTable();
        EntityMetadata entityMetadata = entityTable.getEntityMetadata();
        Class<?> entityClass = entityMetadata.getEntityClass();
        SegmentIndex predicateIndex = sqlWhere.buildPredicateIndex();
        Collection<String> properties = entityMetadata.getProperties();
        boolean hasSetIgnoreColumns = EasySQLSegmentUtil.isNotEmpty(this.setIgnoreColumns);
        boolean envTracked = this.runtimeContext.getTrackManager().currentThreadTracking();
        for (String property : properties) {
            EntityTrackProperty entityTrackProperty;
            ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(property);
            if (columnMetadata.isPrimary() || columnMetadata.isVersion() || columnMetadata.isValueObject() || columnMetadata.isUpdateIgnore() && !columnMetadata.isUpdateSetInTrackDiff() || entityUpdateSetProcessor.shouldRemove(property) || (columnMetadata.isUpdateIgnore() && columnMetadata.isUpdateSetInTrackDiff() || predicateIndex.contains(entityClass, property)) && ((entityTrackProperty = entityUpdateSetProcessor.getEntityTrackProperty()) == null || !entityTrackProperty.getDiffProperties().containsKey(property)) || hasSetIgnoreColumns && this.setIgnoreColumns.containsOnce(entityClass, property)) continue;
            updateSetSQLBuilderSegment.append(new UpdateColumnSegmentImpl(entityTable, property, this.getExpressionContext()));
        }
        return this.processVersionColumn(updateSetSQLBuilderSegment, entityTable);
    }

    protected PredicateSegment buildPropertyWhere(EntityTableExpressionBuilder tableExpressionBuilder, Object entity, TrackContext trackContext, EntityUpdateSetProcessor entityUpdateSetProcessor) {
        AndPredicateSegment where = new AndPredicateSegment(true);
        if (EasySQLSegmentUtil.isNotEmpty(this.whereColumns)) {
            for (SQLSegment sqlSegment : this.whereColumns.getSQLSegments()) {
                if (!(sqlSegment instanceof SQLEntitySegment)) {
                    throw new EasyQueryException("where expression sql segment not instanceof SQLEntitySegment");
                }
                SQLEntitySegment sqlEntitySegment = (SQLEntitySegment)sqlSegment;
                this.buildWhereByProperty(where, trackContext, sqlEntitySegment.getPropertyName(), entity, tableExpressionBuilder, true);
            }
        } else {
            EntityMetadata entityMetadata = tableExpressionBuilder.getEntityMetadata();
            Collection<String> keyProperties = entityMetadata.getKeyProperties();
            if (keyProperties.isEmpty()) {
                throw new EasyQueryException("entity:" + EasyClassUtil.getSimpleName(entityMetadata.getEntityClass()) + " not found primary key properties");
            }
            for (String keyProperty : keyProperties) {
                this.buildWhereByProperty(where, trackContext, keyProperty, entity, tableExpressionBuilder, false);
            }
        }
        return where;
    }

    protected void buildWhereByProperty(PredicateSegment where, TrackContext trackContext, String propertyName, Object entity, EntityTableExpressionBuilder tableExpressionBuilder, boolean nullAssert) {
        if (entity != null) {
            EntityPredicateValue predicateValue = this.getPredicateValue(entity, trackContext, propertyName, tableExpressionBuilder.getEntityMetadata());
            if (nullAssert && predicateValue.getPredicateValue() == null) {
                ColumnNullAssertPredicate columnPredicate = new ColumnNullAssertPredicate(tableExpressionBuilder.getEntityTable(), propertyName, SQLPredicateCompareEnum.IS_NULL, this.getExpressionContext());
                AndPredicateSegment andPredicateSegment = new AndPredicateSegment(columnPredicate);
                where.addPredicateSegment(andPredicateSegment);
            } else if (predicateValue.isTrack()) {
                ColumnEqualsTrackPropertyPredicate columnPropertyPredicate = new ColumnEqualsTrackPropertyPredicate(tableExpressionBuilder.getEntityTable(), propertyName, this.getExpressionContext(), SQLPredicateCompareEnum.EQ);
                AndPredicateSegment andPredicateSegment = new AndPredicateSegment(columnPropertyPredicate);
                where.addPredicateSegment(andPredicateSegment);
            } else {
                ColumnEqualsPropertyPredicate columnPropertyPredicate = new ColumnEqualsPropertyPredicate(tableExpressionBuilder.getEntityTable(), propertyName, this.getExpressionContext());
                AndPredicateSegment andPredicateSegment = new AndPredicateSegment(columnPropertyPredicate);
                where.addPredicateSegment(andPredicateSegment);
            }
        } else {
            ColumnEqualsPropertyPredicate columnPropertyPredicate = new ColumnEqualsPropertyPredicate(tableExpressionBuilder.getEntityTable(), propertyName, this.getExpressionContext());
            AndPredicateSegment andPredicateSegment = new AndPredicateSegment(columnPropertyPredicate);
            where.addPredicateSegment(andPredicateSegment);
        }
    }

    protected EntityPredicateValue getPredicateValue(Object entity, TrackContext trackContext, String propertyName, EntityMetadata entityMetadata) {
        Object originalEntity;
        EntityState trackEntityState;
        ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(propertyName);
        if (trackContext != null && (trackEntityState = trackContext.getTrackEntityState(entity)) != null && (originalEntity = trackEntityState.getOriginalValue()) != null) {
            Object predicateValue = EasyBeanUtil.getPropertyValue(originalEntity, entityMetadata, columnMetadata);
            return new EntityPredicateValue(true, predicateValue);
        }
        Object predicateValue = EasyBeanUtil.getPropertyValue(entity, entityMetadata, columnMetadata);
        return new EntityPredicateValue(false, predicateValue);
    }

    @Override
    public EntityUpdateExpressionBuilder cloneEntityExpressionBuilder() {
        EntityUpdateExpressionBuilder updateExpressionBuilder = this.runtimeContext.getExpressionBuilderFactory().createEntityUpdateExpressionBuilder(this.expressionContext, this.queryClass, this.isExpressionUpdate);
        if (this.hasSetColumns()) {
            this.getSetColumns().copyTo(updateExpressionBuilder.getSetColumns());
        }
        if (this.hasWhere()) {
            this.getWhere().copyTo(updateExpressionBuilder.getWhere());
        }
        if (this.hasSetIgnoreColumns()) {
            this.getSetIgnoreColumns().copyTo(updateExpressionBuilder.getSetIgnoreColumns());
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.whereColumns)) {
            this.whereColumns.copyTo(updateExpressionBuilder.getWhereColumns());
        }
        if (this.columnConfigurers != null) {
            updateExpressionBuilder.getColumnConfigurer().putAll(this.columnConfigurers);
        }
        for (EntityTableExpressionBuilder table : this.tables) {
            updateExpressionBuilder.getTables().add(table.copyEntityTableExpressionBuilder());
        }
        return updateExpressionBuilder;
    }
}

