/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.UpdateSetSQLBuilderSegment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.MapColumnNullAssertPredicate;
import com.easy.query.core.expression.segment.condition.predicate.MapColumnValuePredicate;
import com.easy.query.core.expression.segment.impl.UpdateMapColumnSegmentImpl;
import com.easy.query.core.expression.sql.builder.ColumnConfigurerContext;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.MapUpdateExpressionBuilder;
import com.easy.query.core.expression.sql.builder.internal.AbstractPredicateEntityExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityUpdateSQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class UpdateMapExpressionBuilder
extends AbstractPredicateEntityExpressionBuilder
implements MapUpdateExpressionBuilder {
    private final List<String> whereColumns = new ArrayList<String>(4);

    public UpdateMapExpressionBuilder(ExpressionContext expressionContext) {
        super(expressionContext, Map.class);
    }

    @Override
    public Map<String, ColumnConfigurerContext> getColumnConfigurer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isExpression() {
        return false;
    }

    @Override
    public void addWhereColumns(String ... columnNames) {
        this.whereColumns.addAll(Arrays.asList(columnNames));
    }

    @Override
    public SQLBuilderSegment getSetColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSetColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PredicateSegment getWhere() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasWhere() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLBuilderSegment getSetIgnoreColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSetIgnoreColumns() {
        return false;
    }

    @Override
    public SQLBuilderSegment getWhereColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MapUpdateExpressionBuilder cloneEntityExpressionBuilder() {
        UpdateMapExpressionBuilder mapToUpdateExpressionBuilder = new UpdateMapExpressionBuilder(this.expressionContext);
        mapToUpdateExpressionBuilder.whereColumns.addAll(this.whereColumns);
        for (EntityTableExpressionBuilder table : this.tables) {
            mapToUpdateExpressionBuilder.getTables().add(table.copyEntityTableExpressionBuilder());
        }
        return mapToUpdateExpressionBuilder;
    }

    @Override
    public EntityUpdateSQLExpression toExpression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityUpdateSQLExpression toExpression(Object entity) {
        if (!(entity instanceof Map)) {
            throw new UnsupportedOperationException("map insert can not been null");
        }
        this.checkTable();
        Map map = (Map)EasyObjectUtil.typeCastNullable(entity);
        EntityTableExpressionBuilder entityTableExpressionBuilder = this.getTables().get(0);
        return this.entityToExpression(map, entityTableExpressionBuilder);
    }

    private void checkTable() {
        int tableCount = this.getTables().size();
        if (tableCount == 0) {
            throw new EasyQueryException("\u672a\u627e\u5230\u67e5\u8be2\u8868\u4fe1\u606f");
        }
        if (tableCount > 1) {
            throw new EasyQueryException("\u627e\u5230\u591a\u5f20\u8868\u4fe1\u606f");
        }
    }

    public EntityUpdateSQLExpression entityToExpression(Map<String, Object> map, EntityTableExpressionBuilder tableExpressionBuilder) {
        PredicateSegment where = this.buildPropertyWhere(tableExpressionBuilder, map);
        if (EasySQLSegmentUtil.isEmpty(where)) {
            throw new EasyQueryException("'UPDATE' statement without 'WHERE'");
        }
        SQLBuilderSegment updateSet = this.buildUpdateSetByWhere(where, map, tableExpressionBuilder);
        ExpressionFactory expressionFactory = this.runtimeContext.getExpressionFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, this.runtimeContext);
        EntityUpdateSQLExpression easyUpdateSQLExpression = expressionFactory.createEasyUpdateSQLExpression(entitySQLExpressionMetadata, tableExpressionBuilder.toExpression());
        updateSet.copyTo(easyUpdateSQLExpression.getSetColumns());
        where.copyTo(easyUpdateSQLExpression.getWhere());
        return easyUpdateSQLExpression;
    }

    protected SQLBuilderSegment buildUpdateSetByWhere(PredicateSegment sqlWhere, Map<String, Object> map, EntityTableExpressionBuilder tableExpressionBuilder) {
        UpdateSetSQLBuilderSegment updateSetSQLBuilderSegment = new UpdateSetSQLBuilderSegment();
        TableAvailable entityTable = tableExpressionBuilder.getEntityTable();
        EntityMetadata entityMetadata = entityTable.getEntityMetadata();
        Set<String> columns = map.keySet();
        HashSet<String> ignorePropertySet = new HashSet<String>(map.size());
        boolean clearIgnoreProperties = this.clearIgnoreProperties(ignorePropertySet, this.getRuntimeContext(), map);
        for (String column : columns) {
            if (clearIgnoreProperties && ignorePropertySet.contains(column) || this.whereColumns.contains(column)) continue;
            updateSetSQLBuilderSegment.append(new UpdateMapColumnSegmentImpl(entityTable, column, this.runtimeContext));
        }
        return updateSetSQLBuilderSegment;
    }

    private boolean clearIgnoreProperties(Set<String> ignorePropertySet, QueryRuntimeContext runtimeContext, Map<String, Object> map) {
        if (map != null) {
            SQLExecuteStrategyEnum sqlStrategy = this.expressionContext.getSQLStrategy();
            if (SQLExecuteStrategyEnum.DEFAULT == sqlStrategy) {
                SQLExecuteStrategyEnum globalSQLStrategy = runtimeContext.getQueryConfiguration().getEasyQueryOption().getUpdateStrategy();
                this.getCustomIgnoreProperties(ignorePropertySet, globalSQLStrategy, runtimeContext.getEntityMetadataManager(), map);
                return true;
            }
            this.getCustomIgnoreProperties(ignorePropertySet, sqlStrategy, runtimeContext.getEntityMetadataManager(), map);
            return true;
        }
        return false;
    }

    private void getCustomIgnoreProperties(Set<String> ignoreUpdateSet, SQLExecuteStrategyEnum updateStrategy, EntityMetadataManager entityMetadataManager, Map<String, Object> map) {
        if (Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) || Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NULL_COLUMNS, (Object)updateStrategy)) {
            Predicate<Object> valuePredicate = Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) ? Objects::isNull : Objects::nonNull;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (!valuePredicate.test(value)) continue;
                ignoreUpdateSet.add(entry.getKey());
            }
        }
    }

    protected PredicateSegment buildPropertyWhere(EntityTableExpressionBuilder tableExpressionBuilder, Map<String, Object> map) {
        AndPredicateSegment where = new AndPredicateSegment(true);
        if (EasyCollectionUtil.isEmpty(this.whereColumns)) {
            throw new EasyQueryException("map update whereColumns is empty");
        }
        for (String whereColumn : this.whereColumns) {
            AndPredicateSegment andPredicateSegment;
            Object predicateValue = map.get(whereColumn);
            if (predicateValue == null) {
                MapColumnNullAssertPredicate columnPredicate = new MapColumnNullAssertPredicate(tableExpressionBuilder.getEntityTable(), whereColumn, SQLPredicateCompareEnum.IS_NULL, this.runtimeContext);
                andPredicateSegment = new AndPredicateSegment(columnPredicate);
                where.addPredicateSegment(andPredicateSegment);
                continue;
            }
            MapColumnValuePredicate columnValuePredicate = new MapColumnValuePredicate(tableExpressionBuilder.getEntityTable(), whereColumn, predicateValue, SQLPredicateCompareEnum.EQ, this.runtimeContext);
            andPredicateSegment = new AndPredicateSegment(columnValuePredicate);
            where.addPredicateSegment(andPredicateSegment);
        }
        return where;
    }
}

