/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl.ignore;

import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.EntityTrackProperty;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.basic.extension.track.TrackDiffEntry;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EntityUpdateTypeEnum;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.util.EasyBeanUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class EntityUpdateSetProcessor {
    private final Object entity;
    private final QueryRuntimeContext runtimeContext;
    private final Set<String> entityPropertiesIgnore;
    private final SQLExecuteStrategyEnum expressionUpdateStrategy;
    private EntityTrackProperty entityTrackProperty;
    private EntityUpdateTypeEnum entityUpdateType = EntityUpdateTypeEnum.ENTITY_NULL;

    public EntityUpdateSetProcessor(Object entity, ExpressionContext expressionContext) {
        this.entity = entity;
        this.runtimeContext = expressionContext.getRuntimeContext();
        this.entityPropertiesIgnore = new HashSet<String>();
        this.expressionUpdateStrategy = expressionContext.getSQLStrategy();
        this.initIgnoreProperties();
    }

    private void initIgnoreProperties() {
        if (this.entity != null) {
            if (SQLExecuteStrategyEnum.DEFAULT != this.expressionUpdateStrategy) {
                this.entityUpdateType = EntityUpdateTypeEnum.CUSTOM;
                this.getCustomIgnoreProperties(this.expressionUpdateStrategy, this.runtimeContext.getEntityMetadataManager());
            } else {
                TrackContext trackContext;
                EntityState trackEntityState;
                TrackManager trackManager = this.runtimeContext.getTrackManager();
                if (trackManager.currentThreadTracking() && (trackEntityState = (trackContext = trackManager.getCurrentTrackContext()).getTrackEntityState(this.entity)) != null) {
                    this.entityUpdateType = EntityUpdateTypeEnum.TRACK;
                    this.entityTrackProperty = EasyTrackUtil.getTrackDiffProperty(this.runtimeContext.getEntityMetadataManager(), trackEntityState);
                    this.entityPropertiesIgnore.addAll(this.entityTrackProperty.getSameProperties());
                    return;
                }
                this.entityUpdateType = EntityUpdateTypeEnum.GLOBAL_CUSTOM;
                SQLExecuteStrategyEnum globalUpdateStrategy = this.runtimeContext.getQueryConfiguration().getEasyQueryOption().getUpdateStrategy();
                this.getCustomIgnoreProperties(globalUpdateStrategy, this.runtimeContext.getEntityMetadataManager());
            }
        }
    }

    private void getCustomIgnoreProperties(SQLExecuteStrategyEnum updateStrategy, EntityMetadataManager entityMetadataManager) {
        if (Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) || Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NULL_COLUMNS, (Object)updateStrategy)) {
            Set<String> beanMatchProperties = EasyBeanUtil.getBeanMatchProperties(entityMetadataManager, this.entity, Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) ? Objects::isNull : Objects::nonNull);
            this.entityPropertiesIgnore.addAll(beanMatchProperties);
        }
    }

    public boolean shouldRemove(String property) {
        return this.entity != null && this.entityPropertiesIgnore.contains(property);
    }

    public TrackDiffEntry trackValue(String property) {
        if (this.entityTrackProperty != null) {
            return this.entityTrackProperty.getDiffProperties().get(property);
        }
        return null;
    }

    public EntityTrackProperty getEntityTrackProperty() {
        return this.entityTrackProperty;
    }

    public EntityUpdateTypeEnum getEntityUpdateType() {
        return this.entityUpdateType;
    }
}

