/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.internal;

import java.util.HashSet;
import java.util.Set;

public class ExpressionContextInterceptor {
    protected Set<String> useInterceptors;
    protected Set<String> noInterceptors;

    private void clearInterceptors() {
        if (this.useInterceptors != null) {
            this.useInterceptors.clear();
        }
        if (this.noInterceptors != null) {
            this.noInterceptors.clear();
        }
    }

    public void useInterceptor(String name) {
        if (this.noInterceptors != null) {
            this.noInterceptors.remove(name);
        }
        if (this.useInterceptors == null) {
            this.useInterceptors = new HashSet<String>();
        }
        this.useInterceptors.add(name);
    }

    public void noInterceptor(String name) {
        if (this.useInterceptors != null) {
            this.useInterceptors.remove(name);
        }
        if (this.noInterceptors == null) {
            this.noInterceptors = new HashSet<String>();
        }
        this.noInterceptors.add(name);
    }

    public void useInterceptor() {
        this.clearInterceptors();
    }

    public void noInterceptor() {
        this.clearInterceptors();
    }

    public boolean useContains(String name) {
        if (this.useInterceptors == null) {
            return false;
        }
        return this.useInterceptors.contains(name);
    }

    public boolean noContains(String name) {
        if (this.noInterceptors == null) {
            return false;
        }
        return this.noInterceptors.contains(name);
    }

    public void copyTo(ExpressionContextInterceptor expressionContextInterceptor) {
        if (this.useInterceptors != null) {
            for (String useInterceptor : this.useInterceptors) {
                expressionContextInterceptor.useContains(useInterceptor);
            }
        }
        if (this.noInterceptors != null) {
            for (String noInterceptor : this.noInterceptors) {
                expressionContextInterceptor.noInterceptor(noInterceptor);
            }
        }
    }
}

