/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.expression.impl;

import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.sql.expression.EntityInsertSQLExpression;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class InsertSQLExpressionImpl
implements EntityInsertSQLExpression {
    protected final SQLBuilderSegment columns;
    protected final List<EntityTableSQLExpression> tables = new ArrayList<EntityTableSQLExpression>(1);
    protected final EntitySQLExpressionMetadata entitySQLExpressionMetadata;
    protected List<String> duplicateKeys;
    protected SQLBuilderSegment duplicateKeyUpdateColumns;

    public InsertSQLExpressionImpl(EntitySQLExpressionMetadata entitySQLExpressionMetadata, EntityTableSQLExpression table) {
        this.entitySQLExpressionMetadata = entitySQLExpressionMetadata;
        this.tables.add(table);
        this.columns = new ProjectSQLBuilderSegmentImpl();
    }

    @Override
    public List<EntityTableSQLExpression> getTables() {
        return this.tables;
    }

    @Override
    public SQLBuilderSegment getColumns() {
        return this.columns;
    }

    @Override
    public SQLBuilderSegment getDuplicateKeyUpdateColumns() {
        if (this.duplicateKeyUpdateColumns == null) {
            this.duplicateKeyUpdateColumns = new ProjectSQLBuilderSegmentImpl();
        }
        return this.duplicateKeyUpdateColumns;
    }

    @Override
    @Nullable
    public List<String> getDuplicateKeys() {
        return this.duplicateKeys;
    }

    @Override
    public void addDuplicateKey(String duplicateKey) {
        if (this.duplicateKeys == null) {
            this.duplicateKeys = new ArrayList<String>();
        }
        if (!this.duplicateKeys.contains(duplicateKey)) {
            this.duplicateKeys.add(duplicateKey);
        }
    }

    @Override
    public EntitySQLExpressionMetadata getExpressionMetadata() {
        return this.entitySQLExpressionMetadata;
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.entitySQLExpressionMetadata.getRuntimeContext();
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        EasySQLExpressionUtil.expressionInvokeRoot(toSQLContext);
        EntityTableSQLExpression easyTableSQLExpression = this.tables.get(0);
        String tableName = easyTableSQLExpression.toSQL(toSQLContext);
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(tableName).append(" (");
        Iterator<SQLSegment> iterator = this.columns.getSQLSegments().iterator();
        SQLSegment firstColumn = iterator.next();
        sql.append(this.getColumnNameWithOwner(firstColumn, toSQLContext));
        while (iterator.hasNext()) {
            SQLSegment next = iterator.next();
            sql.append(",").append(this.getColumnNameWithOwner(next, toSQLContext));
        }
        sql.append(") VALUES (").append(this.columns.toSQL(toSQLContext)).append(")");
        return sql.toString();
    }

    protected String getColumnNameWithOwner(SQLSegment sqlSegment, ToSQLContext toSQLContext) {
        InsertUpdateSetColumnSQLSegment columnInsertSegment = (InsertUpdateSetColumnSQLSegment)sqlSegment;
        return columnInsertSegment.getColumnNameWithOwner(toSQLContext);
    }

    @Override
    public EntityInsertSQLExpression cloneSQLExpression() {
        ExpressionFactory expressionFactory = this.entitySQLExpressionMetadata.getRuntimeContext().getExpressionFactory();
        EntityInsertSQLExpression easyInsertSQLExpression = expressionFactory.createEasyInsertSQLExpression(this.entitySQLExpressionMetadata, this.tables.get(0).cloneSQLExpression());
        if (EasySQLSegmentUtil.isNotEmpty(this.columns)) {
            this.columns.copyTo(easyInsertSQLExpression.getColumns());
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.duplicateKeyUpdateColumns)) {
            this.duplicateKeyUpdateColumns.copyTo(easyInsertSQLExpression.getDuplicateKeyUpdateColumns());
        }
        if (EasyCollectionUtil.isNotEmpty(this.duplicateKeys)) {
            for (String duplicateKey : this.duplicateKeys) {
                easyInsertSQLExpression.addDuplicateKey(duplicateKey);
            }
        }
        return easyInsertSQLExpression;
    }

    protected SQLBuilderSegment getRealDuplicateKeyUpdateColumns() {
        if (EasySQLSegmentUtil.isNotEmpty(this.duplicateKeyUpdateColumns)) {
            return this.duplicateKeyUpdateColumns;
        }
        return this.columns;
    }

    protected Set<String> getColumnsSet(SQLBuilderSegment sqlBuilderSegment) {
        List<SQLSegment> sqlSegments = sqlBuilderSegment.getSQLSegments();
        if (EasyCollectionUtil.isEmpty(sqlSegments)) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(sqlSegments.size());
        for (SQLSegment sqlSegment : sqlSegments) {
            if (!(sqlSegment instanceof SQLEntitySegment)) continue;
            SQLEntitySegment sqlEntitySegment = (SQLEntitySegment)sqlSegment;
            set.add(sqlEntitySegment.getPropertyName());
        }
        return set;
    }
}

