/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.expression.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.MultiTableTypeEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.function.Function;

public class TableSQLExpressionImpl
implements EntityTableSQLExpression {
    protected final MultiTableTypeEnum multiTableType;
    protected final QueryRuntimeContext runtimeContext;
    protected final SQLKeyword SQLKeyWord;
    protected final TableAvailable entityTable;
    protected PredicateSegment on;
    protected Function<String, String> tableNameAs;
    protected Function<String, String> schemaAs;
    protected Function<String, String> linkAs;

    public TableSQLExpressionImpl(TableAvailable entityTable, MultiTableTypeEnum multiTableType, QueryRuntimeContext runtimeContext) {
        this.entityTable = entityTable;
        this.multiTableType = multiTableType;
        this.runtimeContext = runtimeContext;
        this.SQLKeyWord = runtimeContext.getQueryConfiguration().getDialect();
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return this.entityTable.getEntityMetadata();
    }

    @Override
    public TableAvailable getEntityTable() {
        return this.entityTable;
    }

    public Function<String, String> getTableNameAs() {
        return this.tableNameAs;
    }

    @Override
    public void setTableNameAs(Function<String, String> tableNameAs) {
        this.tableNameAs = tableNameAs;
    }

    @Override
    public void setSchemaAs(Function<String, String> schemaAs) {
        this.schemaAs = schemaAs;
    }

    @Override
    public void setLinkAs(Function<String, String> linkAs) {
        this.linkAs = linkAs;
    }

    @Override
    public boolean tableNameIsAs() {
        return this.tableNameAs != null;
    }

    public String getSelectTableSource() {
        if (this.linkAs != null) {
            return this.linkAs.apply(this.multiTableType.getAppendSQL());
        }
        return this.multiTableType.getAppendSQL();
    }

    @Override
    public String getTableName() {
        String tableName = this.SQLKeyWord.getQuoteName(this.doGetTableName());
        String schema = this.doGetSchema();
        if (EasyStringUtil.isNotBlank(schema)) {
            return this.SQLKeyWord.getQuoteName(schema) + "." + tableName;
        }
        return tableName;
    }

    protected String doGetSchema() {
        if (this.entityTable.hasSchema() || this.schemaAs != null) {
            String schema = this.entityTable.getSchema();
            if (this.schemaAs != null) {
                return this.schemaAs.apply(schema);
            }
            return schema;
        }
        return null;
    }

    protected String doGetTableName() {
        String tableName = this.entityTable.getTableName();
        if (this.tableNameAs != null) {
            String applyTableName = this.tableNameAs.apply(tableName);
            return this.checkTableName(applyTableName);
        }
        return this.checkTableName(tableName);
    }

    private String checkTableName(String tableName) {
        if (tableName == null) {
            throw new EasyQueryException("table " + EasyClassUtil.getSimpleName(this.entityTable.getEntityClass()) + " cant found mapping table name");
        }
        return tableName;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        boolean none;
        EasySQLExpressionUtil.expressionInvokeRoot(toSQLContext);
        EasySQLExpressionUtil.tableSQLExpressionRewrite(toSQLContext, this);
        StringBuilder sql = new StringBuilder();
        boolean bl = none = MultiTableTypeEnum.NONE == this.multiTableType;
        if (!none) {
            sql.append(" ");
        }
        sql.append(this.getSelectTableSource());
        if (!none) {
            sql.append(" ");
        }
        sql.append(this.getTableName());
        String tableAlias = EasySQLExpressionUtil.getTableAlias(toSQLContext, this.entityTable);
        if (tableAlias != null) {
            sql.append(" ").append(tableAlias);
        }
        return sql.toString();
    }

    @Override
    public PredicateSegment getOn() {
        return this.on;
    }

    @Override
    public void setOn(PredicateSegment predicateSegment) {
        this.on = predicateSegment;
    }

    @Override
    public EntityTableSQLExpression cloneSQLExpression() {
        EntityTableSQLExpression tableSQLExpression = this.runtimeContext.getExpressionFactory().createEntityTableSQLExpression(this.entityTable, this.multiTableType, this.runtimeContext);
        if (EasySQLSegmentUtil.isNotEmpty(this.on)) {
            PredicateSegment predicateSegment = this.on.clonePredicateSegment();
            tableSQLExpression.setOn(predicateSegment);
        }
        tableSQLExpression.setTableNameAs(this.tableNameAs);
        tableSQLExpression.setSchemaAs(this.schemaAs);
        tableSQLExpression.setLinkAs(this.linkAs);
        return tableSQLExpression;
    }
}

