/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.expression.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.UpdateSetSQLBuilderSegment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.expression.sql.expression.EntityUpdateSQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.ArrayList;
import java.util.List;

public class UpdateSQLExpressionImpl
implements EntityUpdateSQLExpression {
    private static final Log log = LogFactory.getLog(UpdateSQLExpressionImpl.class);
    protected final SQLBuilderSegment setColumns;
    protected final PredicateSegment where;
    protected final List<EntityTableSQLExpression> tables = new ArrayList<EntityTableSQLExpression>(1);
    private final EntitySQLExpressionMetadata entitySQLExpressionMetadata;

    public UpdateSQLExpressionImpl(EntitySQLExpressionMetadata entitySQLExpressionMetadata, EntityTableSQLExpression table) {
        this.entitySQLExpressionMetadata = entitySQLExpressionMetadata;
        this.tables.add(table);
        this.setColumns = new UpdateSetSQLBuilderSegment();
        this.where = new AndPredicateSegment(true);
    }

    @Override
    public SQLBuilderSegment getSetColumns() {
        return this.setColumns;
    }

    @Override
    public PredicateSegment getWhere() {
        return this.where;
    }

    @Override
    public List<EntityTableSQLExpression> getTables() {
        return this.tables;
    }

    @Override
    public EntitySQLExpressionMetadata getExpressionMetadata() {
        return this.entitySQLExpressionMetadata;
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.entitySQLExpressionMetadata.getRuntimeContext();
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        EasySQLExpressionUtil.expressionInvokeRoot(toSQLContext);
        if (EasySQLSegmentUtil.isEmpty(this.setColumns)) {
            log.warn("'UPDATE' statement without 'SET',not generate sql execute");
            return null;
        }
        EntityTableSQLExpression easyTableSQLExpression = this.tables.get(0);
        String tableName = easyTableSQLExpression.toSQL(toSQLContext);
        return "UPDATE " + tableName + " SET " + this.setColumns.toSQL(toSQLContext) + " WHERE " + this.where.toSQL(toSQLContext);
    }

    @Override
    public EntityUpdateSQLExpression cloneSQLExpression() {
        ExpressionFactory expressionFactory = this.entitySQLExpressionMetadata.getRuntimeContext().getExpressionFactory();
        EntityUpdateSQLExpression easyUpdateSQLExpression = expressionFactory.createEasyUpdateSQLExpression(this.entitySQLExpressionMetadata, this.tables.get(0).cloneSQLExpression());
        if (EasySQLSegmentUtil.isNotEmpty(this.where)) {
            this.where.copyTo(easyUpdateSQLExpression.getWhere());
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.setColumns)) {
            this.setColumns.copyTo(easyUpdateSQLExpression.getSetColumns());
        }
        return easyUpdateSQLExpression;
    }
}

