/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.include;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.metadata.RelationExtraColumn;
import com.easy.query.core.util.EasyClassUtil;
import java.util.Map;
import java.util.Objects;

public class RelationExtraEntityImpl
implements RelationExtraEntity {
    private final Object entity;
    private final Map<String, Object> extraColumns;
    private final Map<String, RelationExtraColumn> relationExtraColumnMap;

    public RelationExtraEntityImpl(Object entity, Map<String, Object> extraColumns, Map<String, RelationExtraColumn> relationExtraColumnMap) {
        this.relationExtraColumnMap = relationExtraColumnMap;
        Objects.requireNonNull(entity, "entity is null");
        Objects.requireNonNull(extraColumns, "extraColumns is null");
        this.entity = entity;
        this.extraColumns = extraColumns;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public Object getRelationExtraColumn(String propertyName) {
        RelationExtraColumn relationExtraColumn = this.relationExtraColumnMap.get(propertyName);
        if (relationExtraColumn == null) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getInstanceSimpleName(this.entity) + " cant get relation column:" + propertyName);
        }
        if (relationExtraColumn.isAppendRelationExtra()) {
            return this.extraColumns.get(propertyName);
        }
        return relationExtraColumn.getColumnMetadata().getGetterCaller().apply(this.entity);
    }
}

