/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func;

import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.SQLTableOwner;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.ColumnFuncSelector;
import com.easy.query.core.func.column.ColumnFuncSelectorImpl;
import com.easy.query.core.util.EasyArrayUtil;
import java.util.ArrayList;
import java.util.List;

public interface SQLStringFunc {
    default public SQLFunction concat(String property1, String property2, String ... properties) {
        return this.concat((ColumnFuncSelector s) -> {
            s.column(property1).column(property2);
            if (EasyArrayUtil.isNotEmpty(properties)) {
                for (String property : properties) {
                    s.column(property);
                }
            }
        });
    }

    default public SQLFunction concat(SQLExpression1<ColumnFuncSelector> sqlExpression) {
        ArrayList<ColumnExpression> concatExpressions = new ArrayList<ColumnExpression>();
        sqlExpression.apply(new ColumnFuncSelectorImpl(concatExpressions));
        return this.concat(concatExpressions);
    }

    public SQLFunction concat(List<ColumnExpression> var1);

    default public SQLFunction bank(String property) {
        return this.bank((ColumnFuncSelector o) -> o.column(property));
    }

    default public SQLFunction bank(SQLFunction sqlFunction) {
        return this.bank((ColumnFuncSelector o) -> o.sqlFunc(sqlFunction));
    }

    public SQLFunction bank(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction notBank(String property) {
        return this.notBank((ColumnFuncSelector o) -> o.column(property));
    }

    default public SQLFunction notBank(SQLFunction sqlFunction) {
        return this.notBank((ColumnFuncSelector o) -> o.sqlFunc(sqlFunction));
    }

    public SQLFunction notBank(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction empty(String property) {
        return this.empty((ColumnFuncSelector o) -> o.column(property));
    }

    default public SQLFunction empty(SQLFunction sqlFunction) {
        return this.empty((ColumnFuncSelector o) -> o.sqlFunc(sqlFunction));
    }

    public SQLFunction empty(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction notEmpty(String property) {
        return this.notEmpty((ColumnFuncSelector o) -> o.column(property));
    }

    default public SQLFunction notEmpty(SQLFunction sqlFunction) {
        return this.notEmpty((ColumnFuncSelector o) -> o.sqlFunc(sqlFunction));
    }

    public SQLFunction notEmpty(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction toLower(String property) {
        return this.toLower((ColumnFuncSelector s) -> s.column(property));
    }

    default public SQLFunction toLower(SQLFunction sqlFunction) {
        return this.toLower((ColumnFuncSelector s) -> s.sqlFunc(sqlFunction));
    }

    public SQLFunction toLower(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction toUpper(String property) {
        return this.toUpper((ColumnFuncSelector s) -> s.column(property));
    }

    default public SQLFunction toUpper(SQLFunction sqlFunction) {
        return this.toUpper((ColumnFuncSelector s) -> s.sqlFunc(sqlFunction));
    }

    public SQLFunction toUpper(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction subString(String property, int begin, int length) {
        return this.subString(s -> {
            s.column(property);
            s.format(begin + 1);
            s.format(length);
        });
    }

    default public SQLFunction subString(SQLFunction sqlFunction, int begin, int length) {
        return this.subString(s -> {
            s.sqlFunc(sqlFunction);
            s.format(begin + 1);
            s.format(length);
        });
    }

    public SQLFunction subString(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction trim(String property) {
        return this.trim((ColumnFuncSelector s) -> s.column(property));
    }

    default public SQLFunction trim(SQLFunction sqlFunction) {
        return this.trim((ColumnFuncSelector s) -> s.sqlFunc(sqlFunction));
    }

    public SQLFunction trim(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction trimStart(String property) {
        return this.trimStart((ColumnFuncSelector s) -> s.column(property));
    }

    default public SQLFunction trimStart(SQLFunction sqlFunction) {
        return this.trimStart((ColumnFuncSelector s) -> s.sqlFunc(sqlFunction));
    }

    public SQLFunction trimStart(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction trimEnd(String property) {
        return this.trimEnd((ColumnFuncSelector s) -> s.column(property));
    }

    default public SQLFunction trimEnd(SQLFunction sqlFunction) {
        return this.trimEnd((ColumnFuncSelector s) -> s.sqlFunc(sqlFunction));
    }

    public SQLFunction trimEnd(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction replace(String property, String oldValue, String newValue) {
        return this.replace(s -> {
            s.column(property);
            s.value(oldValue);
            s.value(newValue);
        });
    }

    default public SQLFunction replace(SQLFunction sqlFunction, String oldValue, String newValue) {
        return this.replace(s -> {
            s.sqlFunc(sqlFunction);
            s.value(oldValue);
            s.value(newValue);
        });
    }

    public SQLFunction replace(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction stringCompareTo(String property, String comparedValue) {
        return this.stringCompareTo(s -> {
            s.column(property);
            s.value(comparedValue);
        });
    }

    default public SQLFunction stringCompareTo(String property, SQLTableOwner tableOwner, String otherProperty) {
        return this.stringCompareTo(s -> {
            s.column(property);
            s.column(tableOwner, otherProperty);
        });
    }

    default public SQLFunction stringCompareTo(String property, SQLFunction sqlFunction) {
        return this.stringCompareTo(s -> {
            s.column(property);
            s.sqlFunc(sqlFunction);
        });
    }

    default public SQLFunction stringCompareTo(SQLFunction sqlFunction, String comparedValue) {
        return this.stringCompareTo(s -> {
            s.sqlFunc(sqlFunction);
            s.value(comparedValue);
        });
    }

    default public SQLFunction stringCompareTo(SQLFunction sqlFunction, SQLTableOwner tableOwner, String otherProperty) {
        return this.stringCompareTo(s -> {
            s.sqlFunc(sqlFunction);
            s.column(tableOwner, otherProperty);
        });
    }

    default public SQLFunction stringCompareTo(SQLFunction sqlFunction, SQLFunction comparedSQLFunction) {
        return this.stringCompareTo(s -> {
            s.sqlFunc(sqlFunction);
            s.sqlFunc(comparedSQLFunction);
        });
    }

    public SQLFunction stringCompareTo(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction leftPad(String property, int totalWidth) {
        return this.leftPad(s -> {
            s.column(property);
            s.format(totalWidth);
        });
    }

    default public SQLFunction leftPad(String property, int totalWidth, char paddingChar) {
        return this.leftPad(s -> {
            s.column(property);
            s.format(totalWidth);
            s.value(String.valueOf(paddingChar));
        });
    }

    default public SQLFunction leftPad(SQLFunction sqlFunction, int totalWidth) {
        return this.leftPad(s -> {
            s.sqlFunc(sqlFunction);
            s.format(totalWidth);
        });
    }

    default public SQLFunction leftPad(SQLFunction sqlFunction, int totalWidth, char paddingChar) {
        return this.leftPad(s -> {
            s.sqlFunc(sqlFunction);
            s.format(totalWidth);
            s.value(String.valueOf(paddingChar));
        });
    }

    public SQLFunction leftPad(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction rightPad(String property, int totalWidth) {
        return this.rightPad(s -> {
            s.column(property);
            s.format(totalWidth);
        });
    }

    default public SQLFunction rightPad(String property, int totalWidth, char paddingChar) {
        return this.rightPad(s -> {
            s.column(property);
            s.format(totalWidth);
            s.value(String.valueOf(paddingChar));
        });
    }

    default public SQLFunction rightPad(SQLFunction sqlFunction, int totalWidth) {
        return this.rightPad(s -> {
            s.sqlFunc(sqlFunction);
            s.format(totalWidth);
        });
    }

    default public SQLFunction rightPad(SQLFunction sqlFunction, int totalWidth, char paddingChar) {
        return this.rightPad(s -> {
            s.sqlFunc(sqlFunction);
            s.format(totalWidth);
            s.value(String.valueOf(paddingChar));
        });
    }

    public SQLFunction rightPad(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction join(String property, String delimiter) {
        return this.join(s -> {
            s.value(delimiter);
            s.column(property);
        });
    }

    default public SQLFunction join(SQLFunction sqlFunction, String delimiter) {
        return this.join(s -> {
            s.value(delimiter);
            s.sqlFunc(sqlFunction);
        });
    }

    public SQLFunction join(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction length(String property) {
        return this.length((ColumnFuncSelector s) -> s.column(property));
    }

    default public SQLFunction length(SQLFunction sqlFunction) {
        return this.length((ColumnFuncSelector s) -> s.sqlFunc(sqlFunction));
    }

    public SQLFunction length(SQLExpression1<ColumnFuncSelector> var1);

    default public SQLFunction cast(String property, Class<?> targetClazz) {
        return this.cast((ColumnFuncSelector s) -> s.column(property), targetClazz);
    }

    default public SQLFunction cast(SQLFunction sqlFunction, Class<?> targetClazz) {
        return this.cast((ColumnFuncSelector s) -> s.sqlFunc(sqlFunction), targetClazz);
    }

    public SQLFunction cast(SQLExpression1<ColumnFuncSelector> var1, Class<?> var2);
}

